/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.aci;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.apache.directory.shared.ldap.filter.ExprNode;

public abstract class ProtectedItem
implements Serializable {
    public static final Entry ENTRY = new Entry();
    public static final AllUserAttributeTypes ALL_USER_ATTRIBUTE_TYPES = new AllUserAttributeTypes();
    public static final AllUserAttributeTypesAndValues ALL_USER_ATTRIBUTE_TYPES_AND_VALUES = new AllUserAttributeTypesAndValues();

    protected ProtectedItem() {
    }

    public static class RestrictedByItem
    implements Serializable {
        private static final long serialVersionUID = 4319052153538757099L;
        private String attributeType;
        private String valuesIn;

        public RestrictedByItem(String attributeType, String valuesIn) {
            this.attributeType = attributeType;
            this.valuesIn = valuesIn;
        }

        public String getAttributeType() {
            return this.attributeType;
        }

        public String getValuesIn() {
            return this.valuesIn;
        }

        public String toString() {
            return "{ type " + this.attributeType + ", valuesIn " + this.valuesIn + " }";
        }
    }

    public static class MaxValueCountItem
    implements Serializable {
        private static final long serialVersionUID = 43697038363452113L;
        private String attributeType;
        private int maxCount;

        public MaxValueCountItem(String attributeType, int maxCount) {
            this.attributeType = attributeType;
            this.maxCount = maxCount;
        }

        public String getAttributeType() {
            return this.attributeType;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        public String toString() {
            return "{ type " + this.attributeType + ", maxCount " + this.maxCount + " }";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RestrictedBy
    extends ProtectedItem {
        private static final long serialVersionUID = -8157637446588058799L;
        private final Collection<RestrictedByItem> items;

        public RestrictedBy(Collection<RestrictedByItem> items) {
            this.items = Collections.unmodifiableCollection(items);
        }

        public Iterator<RestrictedByItem> iterator() {
            return this.items.iterator();
        }

        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            if (o instanceof RestrictedBy) {
                RestrictedBy that = (RestrictedBy)o;
                return ((Object)this.items).equals(that.items);
            }
            return false;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("restrictedBy {");
            boolean isFirst = true;
            for (RestrictedByItem item : this.items) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(", ");
                }
                buf.append(item.toString());
            }
            buf.append('}');
            return buf.toString();
        }
    }

    public static class MaxImmSub
    extends ProtectedItem {
        private static final long serialVersionUID = -8553151906617285325L;
        private final int value;

        public MaxImmSub(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof MaxImmSub) {
                MaxImmSub that = (MaxImmSub)o;
                return this.value == that.value;
            }
            return false;
        }

        public String toString() {
            return "maxImmSub " + this.value;
        }
    }

    public static class RangeOfValues
    extends ProtectedItem {
        private static final long serialVersionUID = -8553151906617285325L;
        private final ExprNode filter;

        public RangeOfValues(ExprNode filter) {
            if (filter == null) {
                throw new NullPointerException("filter");
            }
            this.filter = filter;
        }

        public ExprNode getFilter() {
            return this.filter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof RangeOfValues) {
                RangeOfValues that = (RangeOfValues)o;
                return this.filter.equals(that.filter);
            }
            return false;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("rangeOfValues ");
            buf.append(this.filter.toString());
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MaxValueCount
    extends ProtectedItem {
        private static final long serialVersionUID = 5261651541488944572L;
        private final Collection<MaxValueCountItem> items;

        public MaxValueCount(Collection<MaxValueCountItem> items) {
            this.items = Collections.unmodifiableCollection(new ArrayList<MaxValueCountItem>(items));
        }

        public Iterator<MaxValueCountItem> iterator() {
            return this.items.iterator();
        }

        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            if (o instanceof MaxValueCount) {
                MaxValueCount that = (MaxValueCount)o;
                return ((Object)this.items).equals(that.items);
            }
            return false;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("maxValueCount {");
            boolean isFirst = true;
            for (MaxValueCountItem item : this.items) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(", ");
                }
                buf.append(item.toString());
            }
            buf.append("}");
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeValue
    extends ProtectedItem {
        private static final long serialVersionUID = -258318397837951363L;
        private final Collection<Attribute> attributes;

        public AttributeValue(Collection<Attribute> attributes) {
            this.attributes = Collections.unmodifiableCollection(attributes);
        }

        public Iterator<Attribute> iterator() {
            return this.attributes.iterator();
        }

        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            if (o instanceof AttributeValue) {
                AttributeValue that = (AttributeValue)o;
                return ((Object)this.attributes).equals(that.attributes);
            }
            return false;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("attributeValue {");
            Iterator<Attribute> it = this.attributes.iterator();
            while (it.hasNext()) {
                Attribute attribute = it.next();
                buf.append(attribute.getID());
                buf.append('=');
                try {
                    buf.append(attribute.get(0));
                }
                catch (NamingException e) {
                    // empty catch block
                }
                if (!it.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(" }");
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelfValue
    extends AttributeTypeProtectedItem {
        private static final long serialVersionUID = -7788463918070206609L;

        public SelfValue(Collection<String> attributeTypes) {
            super(attributeTypes);
        }

        @Override
        public String toString() {
            return "selfValue " + super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AllAttributeValues
    extends AttributeTypeProtectedItem {
        private static final long serialVersionUID = -9039274739078220203L;

        public AllAttributeValues(Collection<String> attributeTypes) {
            super(attributeTypes);
        }

        @Override
        public String toString() {
            return "allAttributeValues " + super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeType
    extends AttributeTypeProtectedItem {
        private static final long serialVersionUID = -9039274739078220203L;

        public AttributeType(Collection<String> attributeTypes) {
            super(attributeTypes);
        }

        @Override
        public String toString() {
            return "attributeType " + super.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AttributeTypeProtectedItem
    extends ProtectedItem {
        protected final Collection<String> attributeTypes;

        protected AttributeTypeProtectedItem(Collection<String> attributeTypes) {
            this.attributeTypes = Collections.unmodifiableCollection(attributeTypes);
        }

        public Iterator<String> iterator() {
            return this.attributeTypes.iterator();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass().isAssignableFrom(o.getClass())) {
                AttributeTypeProtectedItem that = (AttributeTypeProtectedItem)o;
                return ((Object)this.attributeTypes).equals(that.attributeTypes);
            }
            return false;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("{ ");
            boolean isFirst = true;
            for (String attributeType : this.attributeTypes) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(", ");
                }
                buf.append(attributeType);
            }
            buf.append(" }");
            return buf.toString();
        }
    }

    public static class AllUserAttributeTypesAndValues
    extends ProtectedItem {
        private static final long serialVersionUID = 7250988885983604442L;

        private AllUserAttributeTypesAndValues() {
        }

        public String toString() {
            return "allUserAttributeTypesAndValues";
        }
    }

    public static class AllUserAttributeTypes
    extends ProtectedItem {
        private static final long serialVersionUID = 3728652941148931359L;

        private AllUserAttributeTypes() {
        }

        public String toString() {
            return "allUserAttributeTypes";
        }
    }

    public static class Entry
    extends ProtectedItem {
        private static final long serialVersionUID = -6971482229815999874L;

        private Entry() {
        }

        public String toString() {
            return "entry";
        }
    }

    public static class Classes
    extends ProtectedItem {
        private static final long serialVersionUID = -8553151906617285325L;
        private final ExprNode classes;

        public Classes(ExprNode classes) {
            this.classes = classes;
        }

        public ExprNode getClasses() {
            return this.classes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Classes) {
                Classes that = (Classes)o;
                return this.classes.equals(that.classes);
            }
            return false;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("classes ");
            this.classes.printRefinementToBuffer(buf);
            return buf.toString();
        }
    }
}

