/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.codec.controls.AbstractControl;
import org.apache.directory.shared.ldap.codec.controls.CodecControl;
import org.apache.directory.shared.ldap.codec.controls.ManageDsaITControl;
import org.apache.directory.shared.ldap.codec.controls.replication.syncDoneValue.SyncDoneValueControl;
import org.apache.directory.shared.ldap.codec.controls.replication.syncInfoValue.SyncInfoValueControl;
import org.apache.directory.shared.ldap.codec.controls.replication.syncRequestValue.SyncRequestValueControl;
import org.apache.directory.shared.ldap.codec.controls.replication.syncStateValue.SyncStateValueControl;
import org.apache.directory.shared.ldap.codec.search.controls.pagedSearch.PagedResultsControl;
import org.apache.directory.shared.ldap.codec.search.controls.persistentSearch.PersistentSearchControl;
import org.apache.directory.shared.ldap.codec.search.controls.subentries.SubentriesControl;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.message.control.replication.SynchronizationInfoEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LdapMessageCodec
extends AbstractAsn1Object {
    private int messageId;
    private List<Control> controls;
    private Control currentControl;
    protected int ldapMessageLength;
    private int controlsLength;
    private int controlsSequenceLength;
    private Map<String, Control> codecControls = new HashMap<String, Control>();

    public LdapMessageCodec() {
        AbstractControl control = new PersistentSearchControl();
        this.codecControls.put(control.getOid(), control);
        control = new ManageDsaITControl();
        this.codecControls.put(control.getOid(), control);
        control = new SubentriesControl();
        this.codecControls.put(control.getOid(), control);
        control = new PagedResultsControl();
        this.codecControls.put(control.getOid(), control);
        control = new SyncDoneValueControl();
        this.codecControls.put(control.getOid(), control);
        control = new SyncInfoValueControl(SynchronizationInfoEnum.NEW_COOKIE);
        this.codecControls.put(control.getOid(), control);
        control = new SyncInfoValueControl(SynchronizationInfoEnum.REFRESH_DELETE);
        this.codecControls.put(control.getOid(), control);
        control = new SyncInfoValueControl(SynchronizationInfoEnum.REFRESH_PRESENT);
        this.codecControls.put(control.getOid(), control);
        control = new SyncInfoValueControl(SynchronizationInfoEnum.SYNC_ID_SET);
        this.codecControls.put(control.getOid(), control);
        control = new SyncRequestValueControl();
        this.codecControls.put(control.getOid(), control);
        control = new SyncStateValueControl();
        this.codecControls.put(control.getOid(), control);
    }

    public Control getControls(int i) {
        if (this.controls != null) {
            return this.controls.get(i);
        }
        return null;
    }

    public List<Control> getControls() {
        return this.controls;
    }

    public Control getCurrentControl() {
        return this.currentControl;
    }

    public Control getCodecControl(String oid) {
        return this.codecControls.get(oid);
    }

    public void addControl(Control control) {
        this.currentControl = control;
        if (this.controls == null) {
            this.controls = new ArrayList<Control>();
        }
        this.controls.add(control);
    }

    public void addControls(List<Control> controls) {
        if (this.controls == null) {
            this.controls = controls;
        } else if (controls != null) {
            this.controls.addAll(controls);
        }
    }

    public void initControls() {
        this.controls = new ArrayList<Control>();
    }

    public int getMessageId() {
        return this.messageId;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public abstract MessageTypeEnum getMessageType();

    public abstract String getMessageTypeName();

    protected abstract int computeLengthProtocolOp();

    public int computeLength() {
        this.ldapMessageLength = 2 + Value.getNbBytes((int)this.messageId);
        int protocolOpLength = this.computeLengthProtocolOp();
        this.ldapMessageLength += protocolOpLength;
        if (this.controls != null) {
            this.controlsSequenceLength = 0;
            for (Control control : this.controls) {
                this.controlsSequenceLength += ((CodecControl)((Object)control)).computeLength();
            }
            this.controlsLength = this.controlsSequenceLength;
            this.ldapMessageLength += 1 + TLV.getNbBytes((int)this.controlsSequenceLength) + this.controlsSequenceLength;
        }
        return 1 + this.ldapMessageLength + TLV.getNbBytes((int)this.ldapMessageLength);
    }

    protected abstract void encodeProtocolOp(ByteBuffer var1) throws EncoderException;

    public ByteBuffer encode() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        try {
            bb.put((byte)48);
            bb.put(TLV.getBytes((int)this.ldapMessageLength));
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((String)"ERR_04005", (Object[])new Object[0]));
        }
        Value.encode((ByteBuffer)bb, (int)this.messageId);
        this.encodeProtocolOp(bb);
        if (this.controls != null) {
            bb.put((byte)-96);
            bb.put(TLV.getBytes((int)this.controlsLength));
            for (Control control : this.controls) {
                ((CodecControl)((Object)control)).encode(bb);
            }
        }
        return bb;
    }

    protected String toString(String protocolOp) {
        StringBuffer sb = new StringBuffer();
        sb.append("LdapMessage\n");
        sb.append("    message Id : ").append(this.messageId).append('\n');
        sb.append(protocolOp).append('\n');
        if (this.controls != null) {
            for (Control control : this.controls) {
                sb.append(control);
            }
        }
        return sb.toString();
    }
}

