/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.codec.search.ConnectorFilter;
import org.apache.directory.shared.ldap.codec.search.Filter;
import org.apache.directory.shared.ldap.codec.search.PresentFilter;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.name.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchRequestCodec
extends LdapMessageCodec {
    private DN baseObject;
    private SearchScope scope;
    private int derefAliases;
    private long sizeLimit;
    private int timeLimit;
    private boolean typesOnly;
    private Filter filter;
    private List<EntryAttribute> attributes = new ArrayList<EntryAttribute>();
    private Filter currentFilter;
    private Filter terminalFilter;
    private int searchRequestLength;
    private int attributeDescriptionListLength;

    @Override
    public MessageTypeEnum getMessageType() {
        return MessageTypeEnum.SEARCH_REQUEST;
    }

    @Override
    public String getMessageTypeName() {
        return "SEARCH_REQUEST";
    }

    public List<EntryAttribute> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String attribute) {
        this.attributes.add(new DefaultClientAttribute(attribute));
    }

    public DN getBaseObject() {
        return this.baseObject;
    }

    public void setBaseObject(DN baseObject) {
        this.baseObject = baseObject;
    }

    public int getDerefAliases() {
        return this.derefAliases;
    }

    public void setDerefAliases(int derefAliases) {
        this.derefAliases = derefAliases;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(long sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public boolean isTypesOnly() {
        return this.typesOnly;
    }

    public void setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
    }

    public Filter getCurrentFilter() {
        return this.currentFilter;
    }

    public Filter getTerminalFilter() {
        return this.terminalFilter;
    }

    public void setTerminalFilter(Filter terminalFilter) {
        this.terminalFilter = terminalFilter;
    }

    public void addCurrentFilter(Filter localFilter) throws DecoderException {
        if (this.currentFilter != null) {
            ((ConnectorFilter)this.currentFilter).addFilter(localFilter);
            localFilter.setParent(this.currentFilter);
            if (localFilter instanceof ConnectorFilter) {
                this.currentFilter = localFilter;
            }
        } else {
            this.currentFilter = localFilter;
            this.currentFilter.setParent(this);
            this.filter = localFilter;
        }
    }

    public void setCurrentFilter(Filter filter) {
        this.currentFilter = filter;
    }

    public void unstackFilters(IAsn1Container container) {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        TLV localParent = tlv.getParent();
        Filter localFilter = this.terminalFilter;
        while (localParent != null && localParent.getExpectedLength() == 0) {
            if (localParent.getId() != localFilter.getParent().getTlvId()) {
                localParent = localParent.getParent();
                continue;
            }
            AbstractAsn1Object filterParent = localFilter.getParent();
            if (localFilter instanceof PresentFilter) {
                filterParent = filterParent.getParent();
            } else if (filterParent instanceof Filter) {
                filterParent = filterParent.getParent();
            }
            if (!(filterParent instanceof Filter)) break;
            localFilter = this.currentFilter = (Filter)filterParent;
            localParent = localParent.getParent();
        }
    }

    @Override
    protected int computeLengthProtocolOp() {
        this.searchRequestLength = 0;
        this.searchRequestLength += 1 + TLV.getNbBytes((int)DN.getNbBytes(this.baseObject)) + DN.getNbBytes(this.baseObject);
        this.searchRequestLength += 3;
        this.searchRequestLength += 3;
        this.searchRequestLength += 2 + Value.getNbBytes((long)this.sizeLimit);
        this.searchRequestLength += 2 + Value.getNbBytes((int)this.timeLimit);
        this.searchRequestLength += 3;
        this.searchRequestLength += this.filter.computeLength();
        this.attributeDescriptionListLength = 0;
        if (this.attributes != null && this.attributes.size() != 0) {
            for (EntryAttribute attribute : this.attributes) {
                try {
                    int idLength = attribute.getId().getBytes("UTF-8").length;
                    this.attributeDescriptionListLength += 1 + TLV.getNbBytes((int)idLength) + idLength;
                }
                catch (UnsupportedEncodingException uee) {
                    this.attributeDescriptionListLength += 2;
                }
            }
        }
        this.searchRequestLength += 1 + TLV.getNbBytes((int)this.attributeDescriptionListLength) + this.attributeDescriptionListLength;
        return 1 + TLV.getNbBytes((int)this.searchRequestLength) + this.searchRequestLength;
    }

    @Override
    protected void encodeProtocolOp(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)99);
            buffer.put(TLV.getBytes((int)this.searchRequestLength));
            Value.encode((ByteBuffer)buffer, (byte[])DN.getBytes(this.baseObject));
            Value.encodeEnumerated((ByteBuffer)buffer, (int)this.scope.getScope());
            Value.encodeEnumerated((ByteBuffer)buffer, (int)this.derefAliases);
            Value.encode((ByteBuffer)buffer, (long)this.sizeLimit);
            Value.encode((ByteBuffer)buffer, (int)this.timeLimit);
            Value.encode((ByteBuffer)buffer, (boolean)this.typesOnly);
            this.filter.encode(buffer);
            buffer.put((byte)48);
            buffer.put(TLV.getBytes((int)this.attributeDescriptionListLength));
            if (this.attributes != null && this.attributes.size() != 0) {
                for (EntryAttribute attribute : this.attributes) {
                    Value.encode((ByteBuffer)buffer, (String)attribute.getId());
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((String)"ERR_04005", (Object[])new Object[0]));
        }
    }

    private String buildFilter() {
        if (this.filter == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(").append((Object)this.filter).append(")");
        return sb.toString();
    }

    private String buildAttributes() {
        StringBuffer sb = new StringBuffer();
        if (this.attributes != null) {
            boolean isFirst = true;
            if (this.attributes != null && this.attributes.size() != 0) {
                for (EntryAttribute attribute : this.attributes) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(attribute != null ? attribute.getId() : "<no ID>");
                }
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Search Request\n");
        sb.append("        Base Object : '").append(this.baseObject).append("'\n");
        sb.append("        Scope : ");
        switch (this.scope) {
            case OBJECT: {
                sb.append("base object");
                break;
            }
            case ONELEVEL: {
                sb.append("single level");
                break;
            }
            case SUBTREE: {
                sb.append("whole subtree");
            }
        }
        sb.append("\n");
        sb.append("        Deref Aliases : ");
        switch (this.derefAliases) {
            case 0: {
                sb.append("never Deref Aliases");
                break;
            }
            case 1: {
                sb.append("deref In Searching");
                break;
            }
            case 2: {
                sb.append("deref Finding Base Obj");
                break;
            }
            case 3: {
                sb.append("deref Always");
            }
        }
        sb.append("\n");
        sb.append("        Size Limit : ");
        if (this.sizeLimit == 0L) {
            sb.append("no limit");
        } else {
            sb.append(this.sizeLimit);
        }
        sb.append("\n");
        sb.append("        Time Limit : ");
        if (this.timeLimit == 0) {
            sb.append("no limit");
        } else {
            sb.append(this.timeLimit);
        }
        sb.append("\n");
        sb.append("        Types Only : ").append(this.typesOnly).append("\n");
        sb.append("        Filter : '").append(this.buildFilter()).append("'\n");
        if (this.attributes != null && this.attributes.size() != 0) {
            sb.append("        Attributes : ").append(this.buildAttributes()).append("\n");
        }
        return sb.toString();
    }
}

