/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.comparators;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnComparator
extends LdapComparator<Object> {
    private transient SchemaManager schemaManager;

    public DnComparator(String oid) {
        super(oid);
    }

    @Override
    public int compare(Object obj0, Object obj1) {
        DN dn0 = null;
        DN dn1 = null;
        try {
            dn0 = this.getDn(obj0);
            dn1 = this.getDn(obj1);
        }
        catch (LdapException e) {
            return -1;
        }
        return dn0.compareTo(dn1);
    }

    public DN getDn(Object obj) throws LdapInvalidDnException {
        DN dn = null;
        if (obj instanceof DN) {
            dn = (DN)obj;
            dn = dn.isNormalized() ? dn : DN.normalize(dn, this.schemaManager.getNormalizerMapping());
        } else if (obj instanceof String) {
            dn = new DN((String)obj);
            dn.normalize(this.schemaManager.getNormalizerMapping());
        } else {
            throw new IllegalStateException(I18n.err((String)"ERR_04218", (Object[])new Object[]{obj == null ? null : obj.getClass()}));
        }
        return dn;
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }
}

