/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.trigger;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.StringReader;
import java.text.ParseException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.schema.NormalizerMappingResolver;
import org.apache.directory.shared.ldap.trigger.ReusableAntlrTriggerSpecificationLexer;
import org.apache.directory.shared.ldap.trigger.ReusableAntlrTriggerSpecificationParser;
import org.apache.directory.shared.ldap.trigger.TriggerSpecification;

public class TriggerSpecificationParser {
    private ReusableAntlrTriggerSpecificationParser parser;
    private ReusableAntlrTriggerSpecificationLexer lexer = new ReusableAntlrTriggerSpecificationLexer(new StringReader(""));
    private final boolean isNormalizing;

    public TriggerSpecificationParser() {
        this.parser = new ReusableAntlrTriggerSpecificationParser(this.lexer);
        this.parser.init();
        this.isNormalizing = false;
    }

    public TriggerSpecificationParser(NormalizerMappingResolver resolver) {
        this.parser = new ReusableAntlrTriggerSpecificationParser(this.lexer);
        this.parser.setNormalizerMappingResolver(resolver);
        this.parser.init();
        this.isNormalizing = true;
    }

    private synchronized void reset(String spec) {
        StringReader in = new StringReader(spec);
        this.lexer.prepareNextInput(in);
        this.parser.resetState();
    }

    public synchronized TriggerSpecification parse(String spec) throws ParseException {
        TriggerSpecification triggerSpecification = null;
        if (spec == null || spec.trim().equals("")) {
            return null;
        }
        this.reset(spec);
        try {
            triggerSpecification = this.parser.wrapperEntryPoint();
        }
        catch (TokenStreamException e) {
            String msg = I18n.err((String)"ERR_04333", (Object[])new Object[]{spec, e.getLocalizedMessage()});
            throw new ParseException(msg, 0);
        }
        catch (RecognitionException e) {
            String msg = I18n.err((String)"ERR_04333", (Object[])new Object[]{spec, e.getLocalizedMessage()});
            throw new ParseException(msg, e.getColumn());
        }
        return triggerSpecification;
    }

    public boolean isNormizing() {
        return this.isNormalizing;
    }
}

