/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.LogicalOperatorBase;
import org.apache.drill.common.logical.data.SingleInputOperator;
import org.apache.drill.common.logical.data.SourceOperator;
import org.apache.drill.common.logical.data.visitors.LogicalVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@JsonDeserialize(using=De.class)
@JsonTypeName(value="sequence")
public class Sequence
extends LogicalOperatorBase {
    static final Logger logger = LoggerFactory.getLogger(Sequence.class);
    public boolean openTop;
    public LogicalOperator input;
    @JsonProperty(value="do")
    public List<LogicalOperator> stream;

    private Sequence() {
    }

    @Override
    public <T, X, E extends Throwable> T accept(LogicalVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitSequence(this, value);
    }

    @Override
    public Iterator<LogicalOperator> iterator() {
        return Iterators.singletonIterator((Object)this.stream.get(this.stream.size() - 1));
    }

    private static void throwE(JsonLocation l, String e) throws JsonParseException {
        throw new JsonParseException(e, l);
    }

    private static void throwE(JsonParser jp, String e) throws JsonParseException {
        throw new JsonParseException(e, jp.getCurrentLocation());
    }

    public static class De
    extends StdDeserializer<LogicalOperator> {
        protected De() {
            super(Sequence.class);
        }

        public LogicalOperator deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectIdGenerators.IntSequenceGenerator idGenerator = new ObjectIdGenerators.IntSequenceGenerator();
            JsonLocation start = jp.getCurrentLocation();
            JsonToken t = jp.getCurrentToken();
            LogicalOperator parent = null;
            LogicalOperator first = null;
            LogicalOperator prev = null;
            Integer id = null;
            block10: do {
                String fieldName = jp.getText();
                t = jp.nextToken();
                switch (fieldName) {
                    case "@id": {
                        id = this._parseIntPrimitive(jp, ctxt);
                        break;
                    }
                    case "input": {
                        JavaType tp = ctxt.constructType(LogicalOperator.class);
                        JsonDeserializer d = ctxt.findRootValueDeserializer(tp);
                        parent = (LogicalOperator)d.deserialize(jp, ctxt);
                        break;
                    }
                    case "do": {
                        if (!jp.isExpectedStartArrayToken()) {
                            Sequence.throwE(jp, "The do parameter of sequence should be an array of SimpleOperators.  Expected a JsonToken.START_ARRAY token but received a " + t.name() + "token.");
                        }
                        int pos = 0;
                        while ((t = jp.nextToken()) != JsonToken.END_ARRAY) {
                            JsonLocation l = jp.getCurrentLocation();
                            LogicalOperator o = (LogicalOperator)jp.readValueAs(LogicalOperator.class);
                            if (pos == 0) {
                                if (!(o instanceof SingleInputOperator) && !(o instanceof SourceOperator)) {
                                    Sequence.throwE(l, "The first operator in a sequence must be either a ZeroInput or SingleInput operator.  The provided first operator was not. It was of type " + o.getClass().getName());
                                }
                                first = o;
                            } else {
                                if (!(o instanceof SingleInputOperator)) {
                                    Sequence.throwE(l, "All operators after the first must be single input operators.  The operator at position " + pos + " was not. It was of type " + o.getClass().getName());
                                }
                                SingleInputOperator now = (SingleInputOperator)o;
                                now.setInput(prev);
                            }
                            prev = o;
                            ++pos;
                        }
                        continue block10;
                    }
                    default: {
                        Sequence.throwE(jp, "Unknown field name provided for Sequence: " + jp.getText());
                    }
                }
            } while ((t = jp.nextToken()) != JsonToken.END_OBJECT);
            if (first == null) {
                Sequence.throwE(start, "A sequence must include at least one operator.");
            }
            if (parent == null && first instanceof SingleInputOperator || parent != null && first instanceof SourceOperator) {
                Sequence.throwE(start, "A sequence must either start with a ZeroInputOperator or have a provided input. It cannot have both or neither.");
            }
            if (parent != null && first instanceof SingleInputOperator) {
                ((SingleInputOperator)first).setInput(parent);
            }
            if (id != null) {
                ReadableObjectId rid = ctxt.findObjectId((Object)id, (ObjectIdGenerator)idGenerator);
                rid.bindItem((Object)prev);
            }
            return first;
        }
    }
}

