/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.proto.beans;

import com.dyuproject.protostuff.EnumLite;
import com.dyuproject.protostuff.GraphIOUtil;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.drill.exec.proto.beans.DrillPBError;
import org.apache.drill.exec.proto.beans.QueryId;

public final class QueryResult
implements Externalizable,
Message<QueryResult>,
Schema<QueryResult> {
    static final QueryResult DEFAULT_INSTANCE = new QueryResult();
    private QueryState queryState;
    private QueryId queryId;
    private List<DrillPBError> error;
    private static final HashMap<String, Integer> __fieldMap = new HashMap();

    public static Schema<QueryResult> getSchema() {
        return DEFAULT_INSTANCE;
    }

    public static QueryResult getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public QueryState getQueryState() {
        return this.queryState == null ? QueryState.STARTING : this.queryState;
    }

    public QueryResult setQueryState(QueryState queryState) {
        this.queryState = queryState;
        return this;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public QueryResult setQueryId(QueryId queryId) {
        this.queryId = queryId;
        return this;
    }

    public List<DrillPBError> getErrorList() {
        return this.error;
    }

    public QueryResult setErrorList(List<DrillPBError> error) {
        this.error = error;
        return this;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        GraphIOUtil.mergeDelimitedFrom((DataInput)in, (Object)this, (Schema)this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        GraphIOUtil.writeDelimitedTo((DataOutput)out, (Object)this, (Schema)this);
    }

    public Schema<QueryResult> cachedSchema() {
        return DEFAULT_INSTANCE;
    }

    public QueryResult newMessage() {
        return new QueryResult();
    }

    public Class<QueryResult> typeClass() {
        return QueryResult.class;
    }

    public String messageName() {
        return QueryResult.class.getSimpleName();
    }

    public String messageFullName() {
        return QueryResult.class.getName();
    }

    public boolean isInitialized(QueryResult message) {
        return true;
    }

    public void mergeFrom(Input input, QueryResult message) throws IOException {
        int number = input.readFieldNumber((Schema)this);
        while (true) {
            switch (number) {
                case 0: {
                    return;
                }
                case 1: {
                    message.queryState = QueryState.valueOf(input.readEnum());
                    break;
                }
                case 2: {
                    message.queryId = (QueryId)input.mergeObject((Object)message.queryId, QueryId.getSchema());
                    break;
                }
                case 3: {
                    if (message.error == null) {
                        message.error = new ArrayList<DrillPBError>();
                    }
                    message.error.add((DrillPBError)input.mergeObject(null, DrillPBError.getSchema()));
                    break;
                }
                default: {
                    input.handleUnknownField(number, (Schema)this);
                }
            }
            number = input.readFieldNumber((Schema)this);
        }
    }

    public void writeTo(Output output, QueryResult message) throws IOException {
        if (message.queryState != null) {
            output.writeEnum(1, message.queryState.number, false);
        }
        if (message.queryId != null) {
            output.writeObject(2, (Object)message.queryId, QueryId.getSchema(), false);
        }
        if (message.error != null) {
            for (DrillPBError error : message.error) {
                if (error == null) continue;
                output.writeObject(3, (Object)error, DrillPBError.getSchema(), true);
            }
        }
    }

    public String getFieldName(int number) {
        switch (number) {
            case 1: {
                return "queryState";
            }
            case 2: {
                return "queryId";
            }
            case 3: {
                return "error";
            }
        }
        return null;
    }

    public int getFieldNumber(String name) {
        Integer number = __fieldMap.get(name);
        return number == null ? 0 : number;
    }

    static {
        __fieldMap.put("queryState", 1);
        __fieldMap.put("queryId", 2);
        __fieldMap.put("error", 3);
    }

    public static enum QueryState implements EnumLite<QueryState>
    {
        STARTING(0),
        RUNNING(1),
        COMPLETED(2),
        CANCELED(3),
        FAILED(4),
        CANCELLATION_REQUESTED(5),
        ENQUEUED(6);

        public final int number;

        private QueryState(int number) {
            this.number = number;
        }

        public int getNumber() {
            return this.number;
        }

        public static QueryState valueOf(int number) {
            switch (number) {
                case 0: {
                    return STARTING;
                }
                case 1: {
                    return RUNNING;
                }
                case 2: {
                    return COMPLETED;
                }
                case 3: {
                    return CANCELED;
                }
                case 4: {
                    return FAILED;
                }
                case 5: {
                    return CANCELLATION_REQUESTED;
                }
                case 6: {
                    return ENQUEUED;
                }
            }
            return null;
        }
    }
}

