/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.SocketChannel;
import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.ChannelListenerWithCoordinationId;
import org.apache.drill.exec.rpc.RemoteConnection;
import org.apache.drill.exec.rpc.RequestIdMap;
import org.apache.drill.exec.rpc.ResettableBarrier;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcome;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteConnection
implements RemoteConnection {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRemoteConnection.class);
    private final Channel channel;
    private final WriteManager writeManager;
    private final RequestIdMap requestIdMap = new RequestIdMap();
    private final String clientName;
    private String name;

    public AbstractRemoteConnection(SocketChannel channel, String name) {
        this.channel = channel;
        this.clientName = name;
        this.writeManager = new WriteManager();
        channel.pipeline().addLast(new ChannelHandler[]{new BackPressureHandler()});
    }

    @Override
    public boolean inEventLoop() {
        return this.channel.eventLoop().inEventLoop();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = String.format("%s <--> %s (%s)", this.channel.localAddress(), this.channel.remoteAddress(), this.clientName);
        }
        return this.name;
    }

    @Override
    public final Channel getChannel() {
        return this.channel;
    }

    @Override
    public boolean blockOnNotWritable(RpcOutcomeListener<?> listener) {
        try {
            this.writeManager.waitForWritable();
            return true;
        }
        catch (InterruptedException e) {
            listener.interrupted(e);
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public void setAutoRead(boolean enableAutoRead) {
        this.channel.config().setAutoRead(enableAutoRead);
    }

    @Override
    public boolean isActive() {
        return this.channel != null && this.channel.isActive();
    }

    @Override
    public <V> RpcOutcome<V> getAndRemoveRpcOutcome(int rpcType, int coordinationId, Class<V> clazz) {
        return this.requestIdMap.getAndRemoveRpcOutcome(rpcType, coordinationId, clazz);
    }

    @Override
    public <V> ChannelListenerWithCoordinationId createNewRpcListener(RpcOutcomeListener<V> handler, Class<V> clazz) {
        return this.requestIdMap.createNewRpcListener(handler, clazz, this);
    }

    @Override
    public void recordRemoteFailure(int coordinationId, UserBitShared.DrillPBError failure) {
        this.requestIdMap.recordRemoteFailure(coordinationId, failure);
    }

    @Override
    public void channelClosed(RpcException ex) {
        this.writeManager.disable();
        this.writeManager.setWritable(true);
        this.requestIdMap.channelClosed((Throwable)((Object)ex));
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.getChannel().remoteAddress();
    }

    @Override
    public void close() {
        try {
            this.channel.close().get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("Caught exception while closing channel.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private class BackPressureHandler
    extends ChannelInboundHandlerAdapter {
        private BackPressureHandler() {
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
            AbstractRemoteConnection.this.writeManager.setWritable(ctx.channel().isWritable());
            ctx.fireChannelWritabilityChanged();
        }
    }

    private static class WriteManager {
        private final ResettableBarrier barrier = new ResettableBarrier();
        private volatile boolean disabled = false;

        public WriteManager() {
            this.barrier.openBarrier();
        }

        public void waitForWritable() throws InterruptedException {
            this.barrier.await();
        }

        public void setWritable(boolean isWritable) {
            if (isWritable) {
                this.barrier.openBarrier();
            } else if (!this.disabled) {
                this.barrier.closeBarrier();
            }
        }

        public void disable() {
            this.disabled = true;
        }
    }
}

