/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleRevisionImpl;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.cache.Content;
import org.apache.felix.framework.cache.JarContent;
import org.osgi.framework.PackagePermission;

public class BundleProtectionDomain
extends ProtectionDomain {
    private final WeakReference<BundleRevisionImpl> m_revision;
    private final int m_hashCode;
    private final String m_toString;
    private volatile PermissionCollection m_woven;

    BundleProtectionDomain(BundleRevisionImpl revision, Object certificates) throws MalformedURLException {
        super(new CodeSource(RevisionAsJarURL.create(revision), (Certificate[])certificates), null, null, null);
        this.m_revision = new WeakReference<BundleRevisionImpl>(revision);
        this.m_hashCode = revision.hashCode();
        this.m_toString = "[" + revision + "]";
    }

    BundleRevisionImpl getRevision() {
        return (BundleRevisionImpl)this.m_revision.get();
    }

    @Override
    public boolean implies(Permission permission) {
        Felix felix = this.getFramework();
        return felix != null && felix.impliesBundlePermission(this, permission, false);
    }

    boolean superImplies(Permission permission) {
        return super.implies(permission);
    }

    public boolean impliesDirect(Permission permission) {
        Felix felix = this.getFramework();
        return felix != null && felix.impliesBundlePermission(this, permission, true);
    }

    boolean impliesWoven(Permission permission) {
        return this.m_woven != null && this.m_woven.implies(permission);
    }

    synchronized void addWoven(String s) {
        if (this.m_woven == null) {
            this.m_woven = new Permissions();
        }
        this.m_woven.add(new PackagePermission(s, "import"));
    }

    BundleImpl getBundle() {
        BundleRevisionImpl revision = (BundleRevisionImpl)this.m_revision.get();
        return revision != null ? revision.getBundle() : null;
    }

    Felix getFramework() {
        BundleRevisionImpl revision = (BundleRevisionImpl)this.m_revision.get();
        return revision != null ? revision.getBundle().getFramework() : null;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != BundleProtectionDomain.class) {
            return false;
        }
        if (this.m_hashCode != other.hashCode()) {
            return false;
        }
        return this.m_revision.get() == ((BundleProtectionDomain)other).m_revision.get();
    }

    @Override
    public String toString() {
        return this.m_toString;
    }

    private static final class RevisionAsJarURL
    extends URLStreamHandler {
        private final WeakReference m_revision;

        private RevisionAsJarURL(BundleRevisionImpl revision) {
            this.m_revision = new WeakReference<BundleRevisionImpl>(revision);
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new JarURLConnection(u){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public JarFile getJarFile() throws IOException {
                    BundleRevisionImpl revision = (BundleRevisionImpl)RevisionAsJarURL.this.m_revision.get();
                    if (revision != null) {
                        File target;
                        block22: {
                            Content content = revision.getContent();
                            if (content instanceof JarContent) {
                                return Felix.m_secureAction.openJarFile(((JarContent)content).getFile());
                            }
                            target = Felix.m_secureAction.createTempFile("jar", null, null);
                            Felix.m_secureAction.deleteFileOnExit(target);
                            FileOutputStream output = null;
                            InputStream input = null;
                            IOException rethrow = null;
                            try {
                                output = new FileOutputStream(target);
                                input = new BundleInputStream(content);
                                byte[] buffer = new byte[65536];
                                int i = input.read(buffer);
                                while (i != -1) {
                                    output.write(buffer, 0, i);
                                    i = input.read(buffer);
                                }
                            }
                            catch (IOException ex) {
                                rethrow = ex;
                                return rethrow;
                            }
                            finally {
                                block24: {
                                    block23: {
                                        if (output != null) {
                                            try {
                                                output.close();
                                            }
                                            catch (IOException ex) {
                                                if (rethrow != null) break block23;
                                                rethrow = ex;
                                            }
                                        }
                                    }
                                    if (input != null) {
                                        try {
                                            input.close();
                                        }
                                        catch (IOException ex) {
                                            if (rethrow != null) break block24;
                                            rethrow = ex;
                                        }
                                    }
                                }
                                if (rethrow == null) break block22;
                                throw rethrow;
                            }
                        }
                        return Felix.m_secureAction.openJarFile(target);
                    }
                    throw new IOException("Unable to access bundle revision.");
                }

                @Override
                public void connect() throws IOException {
                }
            };
        }

        private static URL create(BundleRevisionImpl revision) throws MalformedURLException {
            URL url;
            RevisionAsJarURL handler = new RevisionAsJarURL(revision);
            boolean useCachedUrlForCodeSource = Boolean.parseBoolean(revision.getBundle().getFramework().getProperty("felix.bundlecodesource.usecachedurls"));
            if (useCachedUrlForCodeSource) {
                String location = "jar:" + revision.getEntry("/") + "!/";
                return Felix.m_secureAction.createURL(Felix.m_secureAction.createURL(null, "jar:", handler), location, handler);
            }
            String location = revision.getBundle()._getLocation();
            if (location.startsWith("reference:")) {
                location = location.substring("reference:".length());
            }
            try {
                url = Felix.m_secureAction.createURL(Felix.m_secureAction.createURL(null, "jar:", handler), location, null);
            }
            catch (MalformedURLException ex) {
                url = null;
            }
            if (url != null && !url.getProtocol().equalsIgnoreCase("jar")) {
                return url;
            }
            if (url == null) {
                location = "jar:" + revision.getEntry("/") + "!/";
            }
            return Felix.m_secureAction.createURL(Felix.m_secureAction.createURL(null, "jar:", handler), location, handler);
        }
    }

    private static final class OutputStreamBuffer
    extends OutputStream {
        ByteArrayOutputStream m_outBuffer = null;

        private OutputStreamBuffer() {
        }

        @Override
        public void write(int b) {
            this.m_outBuffer.write(b);
        }

        @Override
        public void write(byte[] buffer) throws IOException {
            this.m_outBuffer.write(buffer);
        }

        @Override
        public void write(byte[] buffer, int offset, int length) {
            this.m_outBuffer.write(buffer, offset, length);
        }
    }

    private static final class BundleInputStream
    extends InputStream {
        private final Content m_root;
        private final Enumeration m_content;
        private final OutputStreamBuffer m_outputBuffer = new OutputStreamBuffer();
        private ByteArrayInputStream m_buffer = null;
        private JarOutputStream m_output = null;
        private static final String DUMMY_ENTRY = "__DUMMY-ENTRY__/";

        public BundleInputStream(Content root) throws IOException {
            this.m_root = root;
            ArrayList<String> entries = new ArrayList<String>();
            int count = 0;
            String manifest = null;
            Enumeration<String> e = this.m_root.getEntries();
            while (e.hasMoreElements()) {
                String entry = e.nextElement();
                if (entry.endsWith("/")) continue;
                if (entry.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                    if (manifest != null) continue;
                    manifest = entry;
                    continue;
                }
                if (entry.toUpperCase().startsWith("META-INF/") && entry.indexOf(47, "META-INF/".length()) < 0) {
                    entries.add(count++, entry);
                    continue;
                }
                entries.add(entry);
            }
            entries.add(count++, DUMMY_ENTRY);
            if (manifest == null) {
                manifest = "META-INF/MANIFEST.MF";
            }
            this.m_content = Collections.enumeration(entries);
            this.m_output = new JarOutputStream(this.m_outputBuffer);
            this.readNext(manifest);
            this.m_buffer = new ByteArrayInputStream(this.m_outputBuffer.m_outBuffer.toByteArray());
            this.m_outputBuffer.m_outBuffer = null;
        }

        @Override
        public int read() throws IOException {
            if (this.m_output == null && this.m_buffer == null) {
                return -1;
            }
            if (this.m_buffer != null) {
                int result = this.m_buffer.read();
                if (result == -1) {
                    this.m_buffer = null;
                    return this.read();
                }
                return result;
            }
            if (this.m_content.hasMoreElements()) {
                String current = (String)this.m_content.nextElement();
                this.readNext(current);
                if (!this.m_content.hasMoreElements()) {
                    this.m_output.close();
                    this.m_output = null;
                }
                this.m_buffer = new ByteArrayInputStream(this.m_outputBuffer.m_outBuffer.toByteArray());
                this.m_outputBuffer.m_outBuffer = null;
            } else {
                this.m_output.close();
                this.m_output = null;
            }
            return this.read();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readNext(String path) throws IOException {
            this.m_outputBuffer.m_outBuffer = new ByteArrayOutputStream();
            if (path == DUMMY_ENTRY) {
                JarEntry entry = new JarEntry(path);
                this.m_output.putNextEntry(entry);
            } else {
                InputStream in = null;
                try {
                    in = this.m_root.getEntryAsStream(path);
                    if (in == null) {
                        throw new IOException("Missing entry");
                    }
                    JarEntry entry = new JarEntry(path);
                    this.m_output.putNextEntry(entry);
                    byte[] buffer = new byte[4096];
                    int c = in.read(buffer);
                    while (c != -1) {
                        this.m_output.write(buffer, 0, c);
                        c = in.read(buffer);
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            this.m_output.closeEntry();
            this.m_output.flush();
        }
    }
}

