/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime.activator;

import java.util.ArrayList;
import org.apache.felix.gogo.runtime.CommandProcessorImpl;
import org.apache.felix.gogo.runtime.CommandProxy;
import org.apache.felix.gogo.runtime.threadio.ThreadIOImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.command.CommandProcessor;
import org.osgi.service.command.Converter;
import org.osgi.service.threadio.ThreadIO;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    protected CommandProcessorImpl processor;
    private ThreadIOImpl threadio;
    private ServiceTracker commandTracker;
    private ServiceTracker converterTracker;
    private ServiceRegistration processorRegistration;
    private ServiceRegistration threadioRegistration;

    protected ServiceRegistration newProcessor(ThreadIO tio, BundleContext context) {
        this.processor = new CommandProcessorImpl(tio, context);
        return context.registerService(CommandProcessor.class.getName(), (Object)this.processor, null);
    }

    public void start(BundleContext context) throws Exception {
        this.threadio = new ThreadIOImpl();
        this.threadio.start();
        this.threadioRegistration = context.registerService(ThreadIO.class.getName(), (Object)this.threadio, null);
        this.processorRegistration = this.newProcessor(this.threadio, context);
        this.commandTracker = this.trackOSGiCommands(context);
        this.commandTracker.open();
        this.converterTracker = new ServiceTracker(context, Converter.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                Converter converter = (Converter)super.addingService(reference);
                Activator.this.processor.addConverter(converter);
                return converter;
            }

            public void removedService(ServiceReference reference, Object service) {
                Activator.this.processor.removeConverter((Converter)service);
                super.removedService(reference, service);
            }
        };
        this.converterTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.processorRegistration.unregister();
        this.threadioRegistration.unregister();
        this.commandTracker.close();
        this.converterTracker.close();
        this.threadio.stop();
    }

    private ServiceTracker trackOSGiCommands(BundleContext context) throws InvalidSyntaxException {
        Filter filter = context.createFilter(String.format("(&(%s=*)(%s=*))", "osgi.command.scope", "osgi.command.function"));
        return new ServiceTracker(context, filter, null){

            public Object addingService(ServiceReference reference) {
                Object scope = reference.getProperty("osgi.command.scope");
                Object function = reference.getProperty("osgi.command.function");
                ArrayList<CommandProxy> commands = new ArrayList<CommandProxy>();
                if (scope != null && function != null) {
                    if (function.getClass().isArray()) {
                        for (Object f : (Object[])function) {
                            CommandProxy target = new CommandProxy(this.context, reference, f.toString());
                            Activator.this.processor.addCommand(scope.toString(), (Object)target, f.toString());
                            commands.add(target);
                        }
                    } else {
                        CommandProxy target = new CommandProxy(this.context, reference, function.toString());
                        Activator.this.processor.addCommand(scope.toString(), (Object)target, function.toString());
                        commands.add(target);
                    }
                    return commands;
                }
                return null;
            }

            public void removedService(ServiceReference reference, Object service) {
                Object scope = reference.getProperty("osgi.command.scope");
                Object function = reference.getProperty("osgi.command.function");
                if (scope != null && function != null) {
                    if (!function.getClass().isArray()) {
                        Activator.this.processor.removeCommand(scope.toString(), function.toString());
                    } else {
                        for (Object func : (Object[])function) {
                            Activator.this.processor.removeCommand(scope.toString(), func.toString());
                        }
                    }
                }
                super.removedService(reference, service);
            }
        };
    }
}

