/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class ResourceServlet
extends HttpServlet {
    private final String path;

    public ResourceServlet(String path) {
        this.path = path;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String target = req.getPathInfo();
        if (target == null) {
            target = "";
        }
        if (!target.startsWith("/")) {
            target = target + "/" + target;
        }
        String resName = this.path + target;
        URL url = this.getServletContext().getResource(resName);
        if (url == null) {
            res.sendError(404);
        } else {
            this.handle(req, res, url, resName);
        }
    }

    private void handle(HttpServletRequest req, HttpServletResponse res, URL url, String resName) throws IOException {
        long lastModified;
        String contentType = this.getServletContext().getMimeType(resName);
        if (contentType != null) {
            res.setContentType(contentType);
        }
        if ((lastModified = this.getLastModified(url)) != 0L) {
            res.setDateHeader("Last-Modified", lastModified);
        }
        if (!this.resourceModified(lastModified, req.getDateHeader("If-Modified-Since"))) {
            res.setStatus(304);
        } else {
            this.copyResource(url, res);
        }
    }

    private long getLastModified(URL url) {
        File f;
        String filepath;
        long lastModified = 0L;
        try {
            URLConnection conn = url.openConnection();
            lastModified = conn.getLastModified();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (lastModified == 0L && (filepath = url.getPath()) != null && (f = new File(filepath)).exists()) {
            lastModified = f.lastModified();
        }
        return lastModified;
    }

    private boolean resourceModified(long resTimestamp, long modSince) {
        return (resTimestamp /= 1000L) == 0L || (modSince /= 1000L) == -1L || resTimestamp > modSince;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource(URL url, HttpServletResponse res) throws IOException {
        ServletOutputStream os = null;
        InputStream is = null;
        try {
            int n;
            os = res.getOutputStream();
            is = url.openStream();
            int len = 0;
            byte[] buf = new byte[1024];
            while ((n = is.read(buf, 0, buf.length)) >= 0) {
                os.write(buf, 0, n);
                len += n;
            }
            res.setContentLength(len);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }
}

