/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic;

import java.lang.reflect.Array;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.SubArrayVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.util.Elements;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

public class GenericVisitor
extends EmptyVisitor
implements AnnotationVisitor {
    protected Element element;

    public GenericVisitor(Element element) {
        this.element = element;
    }

    public void visit(String name, Object value) {
        if (value.getClass().isArray()) {
            String v = null;
            int index = Array.getLength(value);
            for (int i = 0; i < index; ++i) {
                v = v == null ? "{" + Array.get(value, i) : v + "," + Array.get(value, i);
            }
            v = v + "}";
            this.element.addAttribute(new Attribute(name, v));
            return;
        }
        if (!(value instanceof Type)) {
            this.element.addAttribute(new Attribute(name, value.toString()));
        } else {
            this.element.addAttribute(new Attribute(name, ((Type)value).getClassName()));
        }
    }

    public AnnotationVisitor visitAnnotation(String name, String descriptor) {
        Element sub = Elements.buildElement(Type.getType(descriptor));
        this.element.addElement(sub);
        return new GenericVisitor(sub);
    }

    public AnnotationVisitor visitArray(String name) {
        return new SubArrayVisitor(this.element, name);
    }

    public void visitEnum(String name, String desc, String value) {
        this.element.addAttribute(new Attribute(name, value));
    }
}

