/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic;

import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.FieldGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.MethodGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.ParameterGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.TypeGenericVisitor;
import org.apache.felix.ipojo.manipulator.spi.AnnotationVisitorFactory;
import org.apache.felix.ipojo.manipulator.spi.BindingContext;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class GenericVisitorFactory
implements AnnotationVisitorFactory {
    private final String m_name;
    private final String m_namespace;

    public GenericVisitorFactory(String name, String namespace) {
        this.m_name = name;
        this.m_namespace = namespace;
    }

    public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
        if (context.getNode() instanceof ClassNode) {
            return new TypeGenericVisitor(context.getWorkbench(), new Element(this.m_name, this.m_namespace));
        }
        if (context.getNode() instanceof FieldNode) {
            return new FieldGenericVisitor(context.getWorkbench(), new Element(this.m_name, this.m_namespace), (FieldNode)context.getNode());
        }
        if (context.getNode() instanceof MethodNode && context.getParameterIndex() == -1) {
            return new MethodGenericVisitor(context.getWorkbench(), new Element(this.m_name, this.m_namespace), (MethodNode)context.getNode());
        }
        return new ParameterGenericVisitor(context.getWorkbench(), new Element(this.m_name, this.m_namespace), (MethodNode)context.getNode(), context.getParameterIndex());
    }

    public String toString() {
        return "GenericVisitorFactory";
    }
}

