/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.felix.ipojo.manipulation.InnerClassManipulator;
import org.apache.felix.ipojo.manipulation.Manipulator;
import org.apache.felix.ipojo.manipulation.annotations.MetadataCollector;
import org.apache.felix.ipojo.manipulator.QuotedTokenizer;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.xml.parser.ParseException;
import org.apache.felix.ipojo.xml.parser.SchemaResolver;
import org.apache.felix.ipojo.xml.parser.XMLMetadataParser;
import org.objectweb.asm.ClassReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Pojoization {
    public static final String IPOJO_PACKAGE_VERSION = " 1.4.0";
    private List m_components;
    private Element[] m_metadata = new Element[0];
    private List m_errors = new ArrayList();
    private List m_warnings = new ArrayList();
    private Map m_classes = new HashMap();
    private List m_referredPackages;
    private boolean m_ignoreAnnotations;
    private boolean m_ignoreLocalXSD;
    private JarFile m_inputJar;
    private File m_dir;
    private File m_manifest;

    private void error(String mes) {
        System.err.println(mes);
        this.m_errors.add(mes);
    }

    public void warn(String mes) {
        this.m_warnings.add(mes);
    }

    public List getErrors() {
        return this.m_errors;
    }

    public void disableAnnotationProcessing() {
        this.m_ignoreAnnotations = true;
    }

    public void setUseLocalXSD() {
        this.m_ignoreLocalXSD = false;
    }

    public void pojoization(File in, File out, InputStream metadata) {
        this.parseXMLMetadata(metadata);
        if (this.m_metadata == null) {
            return;
        }
        try {
            this.m_inputJar = new JarFile(in);
        }
        catch (IOException e) {
            this.error("The input file " + in.getAbsolutePath() + " is not a Jar file");
            return;
        }
        this.computeDeclaredComponents();
        this.manipulateJarFile(out);
        int i = 0;
        while (i < this.m_components.size()) {
            ComponentInfo ci = (ComponentInfo)this.m_components.get(i);
            if (!ci.m_isManipulated) {
                this.error("The component " + ci.m_classname + " is declared but not in the bundle");
            }
            ++i;
        }
    }

    public void pojoization(File in, File out, File metadataFile) {
        if (metadataFile != null) {
            this.parseXMLMetadata(metadataFile);
        }
        try {
            this.m_inputJar = new JarFile(in);
        }
        catch (IOException e) {
            this.error("The input file " + in.getAbsolutePath() + " is not a Jar file");
            return;
        }
        this.computeDeclaredComponents();
        this.manipulateJarFile(out);
        int i = 0;
        while (i < this.m_components.size()) {
            ComponentInfo ci = (ComponentInfo)this.m_components.get(i);
            if (!ci.m_isManipulated) {
                this.error("The component " + ci.m_classname + " is declared but not in the bundle");
            }
            ++i;
        }
    }

    public void directoryPojoization(File directory, File metadataFile, File manifestFile) {
        if (metadataFile != null) {
            this.parseXMLMetadata(metadataFile);
        }
        if (directory.exists() && directory.isDirectory()) {
            this.m_dir = directory;
        } else {
            this.error("The directory " + directory.getAbsolutePath() + " does not exist or is not a directory.");
        }
        if (manifestFile != null) {
            if (manifestFile.exists()) {
                this.m_manifest = manifestFile;
            } else {
                this.error("The manifest file " + manifestFile.getAbsolutePath() + " does not exist");
            }
        }
        this.computeDeclaredComponents();
        this.manipulateDirectory();
        int i = 0;
        while (i < this.m_components.size()) {
            ComponentInfo ci = (ComponentInfo)this.m_components.get(i);
            if (!ci.m_isManipulated) {
                this.error("The component " + ci.m_classname + " is declared but not in the bundle");
            }
            ++i;
        }
    }

    private void computeAnnotations(byte[] inC) {
        ClassReader cr = new ClassReader(inC);
        MetadataCollector xml = new MetadataCollector();
        cr.accept(xml, 0);
        if (xml.isAnnotated()) {
            boolean toskip = false;
            int i = 0;
            while (!toskip && i < this.m_metadata.length) {
                if (!this.m_metadata[i].getName().equals("instance") && this.m_metadata[i].containsAttribute("name") && this.m_metadata[i].getAttribute("name").equalsIgnoreCase(xml.getElem().getAttribute("name"))) {
                    toskip = true;
                    this.warn("The component type " + xml.getElem().getAttribute("name") + " is overriden by the metadata file");
                }
                ++i;
            }
            if (!toskip) {
                if (this.m_metadata != null && this.m_metadata.length > 0) {
                    Element[] newElementsList = new Element[this.m_metadata.length + 1];
                    System.arraycopy(this.m_metadata, 0, newElementsList, 0, this.m_metadata.length);
                    newElementsList[this.m_metadata.length] = xml.getElem();
                    this.m_metadata = newElementsList;
                } else {
                    this.m_metadata = new Element[]{xml.getElem()};
                }
                String name = this.m_metadata[this.m_metadata.length - 1].getAttribute("classname");
                name = name.replace('.', '/');
                name = String.valueOf(name) + ".class";
                this.m_components.add(new ComponentInfo(name, this.m_metadata[this.m_metadata.length - 1]));
            }
        }
    }

    private void manipulateJarFile(File out) {
        this.manipulateComponents();
        this.m_referredPackages = this.getReferredPackages();
        Manifest mf = this.doManifest();
        FileOutputStream fos = null;
        JarOutputStream jos = null;
        try {
            fos = new FileOutputStream(out);
            jos = new JarOutputStream((OutputStream)fos, mf);
        }
        catch (FileNotFoundException e1) {
            this.error("Cannot manipulate the Jar file : the output file " + out.getAbsolutePath() + " is not found");
            return;
        }
        catch (IOException e) {
            this.error("Cannot manipulate the Jar file : cannot access to " + out.getAbsolutePath());
            return;
        }
        try {
            Enumeration<JarEntry> entries = this.m_inputJar.entries();
            while (entries.hasMoreElements()) {
                int c;
                JarEntry curEntry = entries.nextElement();
                if (this.m_classes.containsKey(curEntry.getName())) {
                    int c2;
                    JarEntry je = new JarEntry(curEntry.getName());
                    byte[] outClazz = (byte[])this.m_classes.get(curEntry.getName());
                    if (outClazz.length != 0) {
                        jos.putNextEntry(je);
                        jos.write(outClazz);
                        jos.closeEntry();
                        continue;
                    }
                    jos.putNextEntry(curEntry);
                    InputStream currIn = this.m_inputJar.getInputStream(curEntry);
                    int i = 0;
                    while ((c2 = currIn.read()) >= 0) {
                        jos.write(c2);
                        ++i;
                    }
                    currIn.close();
                    jos.closeEntry();
                    continue;
                }
                if (curEntry.getName().equals("META-INF/MANIFEST.MF")) continue;
                jos.putNextEntry(curEntry);
                InputStream currIn = this.m_inputJar.getInputStream(curEntry);
                int i = 0;
                while ((c = currIn.read()) >= 0) {
                    jos.write(c);
                    ++i;
                }
                currIn.close();
                jos.closeEntry();
            }
        }
        catch (IOException e) {
            this.error("Cannot manipulate the Jar file : " + e.getMessage());
            return;
        }
        try {
            this.m_inputJar.close();
            jos.close();
            fos.close();
            jos = null;
            fos = null;
        }
        catch (IOException e) {
            this.error("Cannot close the new Jar file : " + e.getMessage());
            return;
        }
    }

    private void manipulateDirectory() {
        this.manipulateComponents();
        this.m_referredPackages = this.getReferredPackages();
        Manifest mf = this.doManifest();
        if (mf == null) {
            this.error("Cannot found input manifest");
            return;
        }
        Iterator it = this.m_classes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String classname = (String)entry.getKey();
            byte[] clazz = (byte[])entry.getValue();
            File classFile = new File(this.m_dir, classname);
            try {
                FileOutputStream os = new FileOutputStream(classFile);
                ((OutputStream)os).write(clazz);
                ((OutputStream)os).close();
            }
            catch (IOException e) {
                this.error("Cannot manipulate the file : the output file " + classname + " is not found");
                return;
            }
        }
        if (this.m_manifest == null) {
            this.m_manifest = new File(this.m_dir, "META-INF/MANIFEST.MF");
            if (!this.m_manifest.exists()) {
                this.error("Cannot find the manifest file : " + this.m_manifest.getAbsolutePath());
                return;
            }
        } else if (!this.m_manifest.exists()) {
            this.error("Cannot find the manifest file : " + this.m_manifest.getAbsolutePath());
            return;
        }
        try {
            mf.write(new FileOutputStream(this.m_manifest));
        }
        catch (IOException e) {
            this.error("Cannot write the manifest file : " + e.getMessage());
        }
    }

    private void manipulateComponents() {
        Enumeration entries = this.getClassFiles();
        while (entries.hasMoreElements()) {
            String curName = (String)entries.nextElement();
            try {
                int c;
                InputStream currIn = this.getInputStream(curName);
                byte[] in = new byte[]{};
                while ((c = currIn.read()) >= 0) {
                    byte[] in2 = new byte[in.length + 1];
                    System.arraycopy(in, 0, in2, 0, in.length);
                    in2[in.length] = (byte)c;
                    in = in2;
                }
                currIn.close();
                if (!this.m_ignoreAnnotations) {
                    this.computeAnnotations(in);
                }
                int i = 0;
                while (i < this.m_components.size()) {
                    ComponentInfo ci = (ComponentInfo)this.m_components.get(i);
                    if (ci.m_classname.equals(curName)) {
                        byte[] outClazz = this.manipulateComponent(in, ci);
                        this.m_classes.put(ci.m_classname, outClazz);
                        if (!ci.m_inners.isEmpty()) {
                            int k = 0;
                            while (k < ci.m_inners.size()) {
                                String innerCN = String.valueOf((String)ci.m_inners.get(k)) + ".class";
                                InputStream innerStream = this.getInputStream(innerCN);
                                this.manipulateInnerClass(innerStream, innerCN, ci);
                                ++k;
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                this.error("Cannot read the class : " + curName);
                return;
            }
        }
    }

    private InputStream getInputStream(String classname) throws IOException {
        if (this.m_inputJar != null) {
            JarEntry je;
            if (!classname.endsWith(".class")) {
                classname = String.valueOf(classname) + ".class";
            }
            if ((je = this.m_inputJar.getJarEntry(classname)) == null) {
                throw new IOException("The class " + classname + " connot be found in the input Jar file");
            }
            return this.m_inputJar.getInputStream(je);
        }
        File file = new File(this.m_dir, classname);
        return new FileInputStream(file);
    }

    private Enumeration getClassFiles() {
        Vector<String> files = new Vector<String>();
        if (this.m_inputJar != null) {
            Enumeration<JarEntry> enumeration = this.m_inputJar.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry je = enumeration.nextElement();
                if (!je.getName().endsWith(".class")) continue;
                files.add(je.getName());
            }
        } else {
            this.searchClassFiles(this.m_dir, files);
        }
        return files.elements();
    }

    private void searchClassFiles(File dir, List classes) {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.searchClassFiles(files[i], classes);
            } else if (files[i].getName().endsWith(".class")) {
                classes.add(this.computeRelativePath(files[i].getAbsolutePath()));
            }
            ++i;
        }
    }

    private String computeRelativePath(String absolutePath) {
        String root = this.m_dir.getAbsolutePath();
        return absolutePath.substring(root.length() + 1);
    }

    private void manipulateInnerClass(InputStream clazz, String cn, ComponentInfo ci) throws IOException {
        int c;
        byte[] in = new byte[]{};
        while ((c = clazz.read()) >= 0) {
            byte[] in2 = new byte[in.length + 1];
            System.arraycopy(in, 0, in2, 0, in.length);
            in2[in.length] = (byte)c;
            in = in2;
        }
        InnerClassManipulator man = new InnerClassManipulator(ci.m_classname.substring(0, ci.m_classname.length() - 6), ci.m_fields);
        byte[] out = man.manipulate(in);
        this.m_classes.put(cn, out);
    }

    private Manifest getManifest() throws IOException {
        if (this.m_inputJar != null) {
            return this.m_inputJar.getManifest();
        }
        if (this.m_manifest == null) {
            File manFile = new File(this.m_dir, "META-INF/MANIFEST.MF");
            if (manFile.exists()) {
                return new Manifest(new FileInputStream(manFile));
            }
            throw new IOException("Cannot find the manifest file : " + manFile.getAbsolutePath());
        }
        if (this.m_manifest.exists()) {
            return new Manifest(new FileInputStream(this.m_manifest));
        }
        throw new IOException("Cannot find the manifest file : " + this.m_manifest.getAbsolutePath());
    }

    private Manifest doManifest() {
        Manifest mf = null;
        try {
            mf = this.getManifest();
        }
        catch (IOException e) {
            this.error("Cannot get the manifest : " + e.getMessage());
            return null;
        }
        Attributes att = mf.getMainAttributes();
        this.setImports(att);
        this.setPOJOMetadata(att);
        this.setCreatedBy(att);
        return mf;
    }

    private byte[] manipulateComponent(byte[] in, ComponentInfo ci) {
        Manipulator man = new Manipulator();
        try {
            byte[] out = man.manipulate(in);
            ci.detectMissingFields(man.getFields());
            ci.m_componentMetadata.addElement(man.getManipulationMetadata());
            ci.m_isManipulated = true;
            ci.m_inners = man.getInnerClasses();
            ci.m_fields = man.getFields().keySet();
            return out;
        }
        catch (IOException e) {
            this.error("Cannot manipulate the class " + ci.m_classname + " : " + e.getMessage());
            return null;
        }
    }

    private void computeDeclaredComponents() {
        ArrayList<ComponentInfo> componentClazzes = new ArrayList<ComponentInfo>();
        int i = 0;
        while (i < this.m_metadata.length) {
            String name = this.m_metadata[i].getAttribute("classname");
            if (name != null) {
                name = name.replace('.', '/');
                name = String.valueOf(name) + ".class";
                componentClazzes.add(new ComponentInfo(name, this.m_metadata[i]));
            }
            ++i;
        }
        this.m_components = componentClazzes;
    }

    private void setCreatedBy(Attributes att) {
        String prev = att.getValue("Created-By");
        if (prev == null) {
            att.putValue("Created-By", "iPOJO  1.4.0");
        } else if (prev.indexOf("iPOJO") == -1) {
            att.putValue("Created-By", String.valueOf(prev) + " & iPOJO " + IPOJO_PACKAGE_VERSION);
        }
    }

    private void setImports(Attributes att) {
        TreeMap<String, String> verCM;
        Map imports = this.parseHeader(att.getValue("Import-Package"));
        TreeMap<String, String> ver = new TreeMap<String, String>();
        ver.put("version", IPOJO_PACKAGE_VERSION);
        if (!imports.containsKey("org.apache.felix.ipojo")) {
            imports.put("org.apache.felix.ipojo", ver);
        }
        if (!imports.containsKey("org.apache.felix.ipojo.architecture")) {
            imports.put("org.apache.felix.ipojo.architecture", ver);
        }
        if (!imports.containsKey("org.osgi.service.cm")) {
            verCM = new TreeMap<String, String>();
            verCM.put("version", "1.2");
            imports.put("org.osgi.service.cm", verCM);
        }
        if (!imports.containsKey("org.osgi.service.log")) {
            verCM = new TreeMap();
            verCM.put("version", "1.3");
            imports.put("org.osgi.service.log", verCM);
        }
        int i = 0;
        while (i < this.m_referredPackages.size()) {
            String pack = (String)this.m_referredPackages.get(i);
            imports.put(pack, new TreeMap());
            ++i;
        }
        att.putValue("Import-Package", this.printClauses(imports, "resolution:"));
    }

    private void setPOJOMetadata(Attributes att) {
        StringBuffer meta = new StringBuffer();
        int i = 0;
        while (i < this.m_metadata.length) {
            meta.append(this.buildManifestMetadata(this.m_metadata[i], new StringBuffer()));
            ++i;
        }
        if (meta.length() != 0) {
            att.putValue("iPOJO-Components", meta.toString());
        }
    }

    public Map parseHeader(String value) {
        char del;
        if (value == null || value.trim().length() == 0) {
            return new HashMap();
        }
        HashMap result = new HashMap();
        QuotedTokenizer qt = new QuotedTokenizer(value, ";=,");
        do {
            boolean hadAttribute = false;
            HashMap<String, String> clause = new HashMap<String, String>();
            ArrayList<String> aliases = new ArrayList<String>();
            aliases.add(qt.nextToken());
            del = qt.getSeparator();
            while (del == ';') {
                String adname = qt.nextToken();
                del = qt.getSeparator();
                if (del != '=') {
                    if (hadAttribute) {
                        throw new IllegalArgumentException("Header contains name field after attribute or directive: " + adname + " from " + value);
                    }
                    aliases.add(adname);
                    continue;
                }
                String advalue = qt.nextToken();
                clause.put(adname, advalue);
                del = qt.getSeparator();
                hadAttribute = true;
            }
            Iterator i = aliases.iterator();
            while (i.hasNext()) {
                result.put(i.next(), clause);
            }
        } while (del == ',');
        return result;
    }

    public String printClauses(Map exports, String allowedDirectives) {
        StringBuffer sb = new StringBuffer();
        String del = "";
        Iterator i = exports.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            Map map = (Map)entry.getValue();
            sb.append(del);
            sb.append(name);
            Iterator j = map.entrySet().iterator();
            while (j.hasNext()) {
                boolean dirty;
                Map.Entry entry2 = j.next();
                String key = (String)entry2.getKey();
                if (key.endsWith(":") && allowedDirectives.indexOf(key) < 0) continue;
                String value = (String)entry2.getValue();
                sb.append(";");
                sb.append(key);
                sb.append("=");
                boolean bl = dirty = value.indexOf(44) >= 0 || value.indexOf(59) >= 0;
                if (dirty) {
                    sb.append("\"");
                }
                sb.append(value);
                if (!dirty) continue;
                sb.append("\"");
            }
            del = ", ";
        }
        return sb.toString();
    }

    private void parseXMLMetadata(File metadataFile) {
        try {
            InputStream stream = null;
            URL url = metadataFile.toURL();
            if (url == null) {
                this.warn("Cannot find the metadata file : " + metadataFile.getAbsolutePath());
                this.m_metadata = new Element[0];
            } else {
                stream = url.openStream();
                this.parseXMLMetadata(stream);
            }
        }
        catch (MalformedURLException e) {
            this.error("Cannot open the metadata input stream from " + metadataFile.getAbsolutePath() + ": " + e.getMessage());
            this.m_metadata = null;
        }
        catch (IOException e) {
            this.error("Cannot open the metadata input stream: " + metadataFile.getAbsolutePath() + ": " + e.getMessage());
            this.m_metadata = null;
        }
    }

    private void parseXMLMetadata(InputStream stream) {
        Element[] meta = null;
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            XMLMetadataParser handler = new XMLMetadataParser();
            parser.setContentHandler(handler);
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setErrorHandler(handler);
            if (!this.m_ignoreLocalXSD) {
                parser.setEntityResolver(new SchemaResolver());
            }
            InputSource is = new InputSource(stream);
            parser.parse(is);
            meta = handler.getMetadata();
            stream.close();
        }
        catch (IOException e) {
            this.error("Cannot open the metadata input stream: " + e.getMessage());
        }
        catch (ParseException e) {
            this.error("Parsing error when parsing the XML file: " + e.getMessage());
        }
        catch (SAXParseException e) {
            this.error("Error during metadata parsing at line " + e.getLineNumber() + " : " + e.getMessage());
        }
        catch (SAXException e) {
            this.error("Parsing error when parsing (Sax Error) the XML file: " + e.getMessage());
        }
        if (meta == null || meta.length == 0) {
            this.warn("Neither component types, nor instances in the metadata");
        }
        this.m_metadata = meta;
    }

    private List getReferredPackages() {
        ArrayList<String> referred = new ArrayList<String>();
        int i = 0;
        while (i < this.m_metadata.length) {
            Element[] elems = this.m_metadata[i].getElements();
            int j = 0;
            while (j < elems.length) {
                int last;
                String att = elems[j].getAttribute("specification");
                if (att != null && (last = att.lastIndexOf(46)) != -1) {
                    referred.add(att.substring(0, last));
                }
                ++j;
            }
            ++i;
        }
        return referred;
    }

    private StringBuffer buildManifestMetadata(Element element, StringBuffer actual) {
        StringBuffer result = new StringBuffer();
        if (element.getNameSpace() == null) {
            result.append(actual + element.getName() + " { ");
        } else {
            result.append(actual + element.getNameSpace() + ":" + element.getName() + " { ");
        }
        Attribute[] atts = element.getAttributes();
        int i = 0;
        while (i < atts.length) {
            Attribute current = atts[i];
            if (current.getNameSpace() == null) {
                result.append("$" + current.getName() + "=\"" + current.getValue() + "\" ");
            } else {
                result.append("$" + current.getNameSpace() + ":" + current.getName() + "=\"" + current.getValue() + "\" ");
            }
            ++i;
        }
        Element[] elems = element.getElements();
        int i2 = 0;
        while (i2 < elems.length) {
            result = this.buildManifestMetadata(elems[i2], result);
            ++i2;
        }
        result.append("}");
        return result;
    }

    public List getWarnings() {
        return this.m_warnings;
    }

    private class ComponentInfo {
        Element m_componentMetadata;
        String m_classname;
        boolean m_isManipulated;
        List m_inners;
        Set m_fields;

        ComponentInfo(String cn, Element met) {
            this.m_classname = cn;
            this.m_componentMetadata = met;
            this.m_isManipulated = false;
        }

        void detectMissingFields(Map fields) {
            ArrayList list = new ArrayList();
            this.computeReferredFields(list, this.m_componentMetadata);
            int i = 0;
            while (i < list.size()) {
                if (!fields.containsKey(list.get(i))) {
                    Pojoization.this.error("The field " + list.get(i) + " is referenced in the " + "metadata but does not exist in the " + this.m_classname + " class");
                }
                ++i;
            }
        }

        private void computeReferredFields(List list, Element metadata) {
            String field = metadata.getAttribute("field");
            if (field != null && !list.contains(field)) {
                list.add(field);
            }
            int i = 0;
            while (i < metadata.getElements().length) {
                this.computeReferredFields(list, metadata.getElements()[i]);
                ++i;
            }
        }
    }
}

