/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.spi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.Binding;
import org.apache.felix.ipojo.manipulator.spi.AnnotationVisitorFactory;
import org.apache.felix.ipojo.manipulator.spi.Module;
import org.apache.felix.ipojo.manipulator.spi.Predicate;
import org.apache.felix.ipojo.manipulator.spi.helper.Predicates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsBindingModule
implements Module {
    private List<Binding> bindings = new ArrayList<Binding>();

    @Override
    public Iterator<Binding> iterator() {
        return this.bindings.iterator();
    }

    protected AnnotationBindingBuilder bind(Class<? extends Annotation> annotationType) {
        return new AnnotationBindingBuilder(this.bindings, annotationType);
    }

    public class ConditionalBindingBuilder {
        private AnnotationBindingBuilder parent;
        private Predicate predicate;
        private AnnotationVisitorFactory factory;

        public ConditionalBindingBuilder(AnnotationBindingBuilder parent, Predicate predicate) {
            this.parent = parent;
            this.predicate = predicate;
        }

        public AnnotationBindingBuilder to(AnnotationVisitorFactory factory) {
            this.factory = factory;
            AbsBindingModule.this.bindings.add(this.build());
            return this.parent;
        }

        private Binding build() {
            Binding binding = this.parent.build();
            binding.setPredicate(this.predicate);
            binding.setFactory(this.factory);
            return binding;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AnnotationBindingBuilder {
        private Class<? extends Annotation> annotationType;
        private AnnotationVisitorFactory factory;
        private List<Binding> registry;

        public AnnotationBindingBuilder(List<Binding> registry, Class<? extends Annotation> annotationType) {
            this.registry = registry;
            this.annotationType = annotationType;
        }

        public ConditionalBindingBuilder when(Predicate predicate) {
            return new ConditionalBindingBuilder(this, predicate);
        }

        public void to(AnnotationVisitorFactory factory) {
            this.factory = factory;
            this.registry.add(this.build());
        }

        private Binding build() {
            Binding binding = new Binding();
            binding.setAnnotationType(this.annotationType);
            binding.setPredicate(Predicates.onlySupportedElements(this.annotationType));
            binding.setFactory(this.factory);
            return binding;
        }
    }
}

