/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.resolver.FelixEnvironment;
import org.apache.felix.resolver.Logger;
import org.apache.felix.resolver.impl.HostResource;
import org.apache.felix.resolver.impl.HostedCapability;
import org.apache.felix.resolver.impl.HostedRequirement;
import org.apache.felix.resolver.impl.Util;
import org.osgi.framework.Version;
import org.osgi.framework.resource.Capability;
import org.osgi.framework.resource.Requirement;
import org.osgi.framework.resource.Resource;
import org.osgi.framework.resource.Wire;
import org.osgi.framework.resource.Wiring;
import org.osgi.service.resolver.Environment;
import org.osgi.service.resolver.ResolutionException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Candidates {
    public static final int MANDATORY = 0;
    public static final int OPTIONAL = 1;
    public static final int ON_DEMAND = 2;
    private final Logger m_logger;
    private final Set<Resource> m_mandatoryRevisions;
    private final Map<Capability, Set<Requirement>> m_dependentMap;
    private final Map<Requirement, SortedSet<Capability>> m_candidateMap;
    private final Map<Resource, HostResource> m_allWrappedHosts;
    private final Map<Resource, Object> m_populateResultCache;
    private boolean m_fragmentsPresent = false;

    Candidates(Logger logger, Set<Resource> mandatoryRevisions, Map<Capability, Set<Requirement>> dependentMap, Map<Requirement, SortedSet<Capability>> candidateMap, Map<Resource, HostResource> wrappedHosts, Map<Resource, Object> populateResultCache, boolean fragmentsPresent) {
        this.m_logger = logger;
        this.m_mandatoryRevisions = mandatoryRevisions;
        this.m_dependentMap = dependentMap;
        this.m_candidateMap = candidateMap;
        this.m_allWrappedHosts = wrappedHosts;
        this.m_populateResultCache = populateResultCache;
        this.m_fragmentsPresent = fragmentsPresent;
    }

    Candidates(Logger logger) {
        this.m_logger = logger;
        this.m_mandatoryRevisions = new HashSet<Resource>();
        this.m_dependentMap = new HashMap<Capability, Set<Requirement>>();
        this.m_candidateMap = new HashMap<Requirement, SortedSet<Capability>>();
        this.m_allWrappedHosts = new HashMap<Resource, HostResource>();
        this.m_populateResultCache = new HashMap<Resource, Object>();
    }

    public final void populate(Environment env, Resource resource, int resolution) {
        block7: {
            Object cacheValue = this.m_populateResultCache.get(resource);
            if (cacheValue instanceof ResolutionException) {
                return;
            }
            if (cacheValue instanceof Boolean) {
                return;
            }
            boolean isFragment = Util.isFragment(resource);
            if (!isFragment && env.getWirings().containsKey(resource)) {
                return;
            }
            if (resolution != 2 || isFragment && this.populateFragmentOndemand(env, resource)) {
                if (resolution == 0) {
                    this.m_mandatoryRevisions.add(resource);
                }
                try {
                    this.populateRevision(env, resource);
                }
                catch (ResolutionException ex) {
                    if (resolution != 0) break block7;
                    throw ex;
                }
            }
        }
    }

    private void populateRevision(Environment env, Resource resource) {
        Integer cycleCount = null;
        Map<Requirement, SortedSet<Capability>> localCandidateMap = null;
        List<Requirement> remainingReqs = null;
        Object[] cacheValue = this.m_populateResultCache.get(resource);
        if (cacheValue instanceof ResolutionException) {
            throw (ResolutionException)cacheValue;
        }
        if (cacheValue instanceof Boolean) {
            return;
        }
        if (cacheValue != null) {
            Integer n = new Integer((Integer)((Object[])cacheValue)[0] + 1);
            ((Object[])cacheValue)[0] = n;
            cycleCount = n;
            localCandidateMap = (Map)((Object[])cacheValue)[1];
            remainingReqs = (List)((Object[])cacheValue)[2];
        }
        if (remainingReqs == null && localCandidateMap == null) {
            ((FelixEnvironment)env).checkExecutionEnvironment(resource);
            ((FelixEnvironment)env).checkNativeLibraries(resource);
            cycleCount = new Integer(0);
            localCandidateMap = new HashMap<Requirement, SortedSet<Capability>>();
            remainingReqs = new ArrayList<Requirement>(resource.getRequirements(null));
            cacheValue = new Object[]{cycleCount, localCandidateMap, remainingReqs};
            this.m_populateResultCache.put(resource, cacheValue);
        }
        while (remainingReqs.size() > 0) {
            Requirement req = (Requirement)remainingReqs.remove(0);
            String resolution = req.getDirectives().get("resolution");
            if (!env.isEffective(req) || resolution != null && resolution.equals("dynamic")) continue;
            SortedSet<Capability> candidates = env.findProviders(req);
            ResolutionException rethrow = this.processCandidates(env, resource, candidates);
            if (candidates.isEmpty() && !Util.isOptional(req)) {
                String msg = new StringBuffer().append("Unable to resolve ").append(resource).append(": missing requirement ").append(req).toString();
                if (rethrow != null) {
                    msg = new StringBuffer().append(msg).append(" [caused by: ").append(rethrow.getMessage()).append("]").toString();
                }
                rethrow = new ResolutionException(msg, null, Collections.singleton(req));
                this.m_populateResultCache.put(resource, rethrow);
                throw rethrow;
            }
            if (candidates.size() <= 0) continue;
            localCandidateMap.put(req, candidates);
        }
        if (cycleCount > 0) {
            ((Object[])cacheValue)[0] = new Integer(cycleCount - 1);
        } else if (cycleCount == 0) {
            this.m_populateResultCache.put(resource, Boolean.TRUE);
            if (localCandidateMap.size() > 0) {
                this.add(localCandidateMap);
            }
        }
    }

    private boolean populateFragmentOndemand(Environment env, Resource resource) throws ResolutionException {
        ArrayList<Requirement> remainingReqs = new ArrayList<Requirement>(resource.getRequirements(null));
        Requirement hostReq = null;
        Iterator it = remainingReqs.iterator();
        while (it.hasNext()) {
            Requirement r = (Requirement)it.next();
            if (!r.getNamespace().equals("osgi.wiring.host")) continue;
            hostReq = r;
            it.remove();
            break;
        }
        SortedSet<Capability> hosts = env.findProviders(hostReq);
        Iterator it2 = hosts.iterator();
        while (it2.hasNext()) {
            Capability host = (Capability)it2.next();
            if (this.isPopulated(host.getResource())) continue;
            it2.remove();
        }
        if (hosts.isEmpty()) {
            return false;
        }
        ((FelixEnvironment)env).checkExecutionEnvironment(resource);
        ((FelixEnvironment)env).checkNativeLibraries(resource);
        Integer cycleCount = new Integer(-1);
        HashMap<Requirement, SortedSet<Capability>> localCandidateMap = new HashMap<Requirement, SortedSet<Capability>>();
        localCandidateMap.put(hostReq, hosts);
        this.m_populateResultCache.put(resource, new Object[]{cycleCount, localCandidateMap, remainingReqs});
        return true;
    }

    public void populateDynamic(Environment env, Resource resource, Requirement req, SortedSet<Capability> candidates) {
        this.m_mandatoryRevisions.add(resource);
        this.add(req, candidates);
        ResolutionException rethrow = this.processCandidates(env, resource, candidates);
        if (candidates.isEmpty()) {
            if (rethrow == null) {
                rethrow = new ResolutionException("Dynamic import failed.", null, Collections.singleton(req));
            }
            throw rethrow;
        }
        this.m_populateResultCache.put(resource, Boolean.TRUE);
    }

    private ResolutionException processCandidates(Environment env, Resource resource, SortedSet<Capability> candidates) {
        ResolutionException rethrow = null;
        HashSet<Capability> fragmentCands = null;
        Iterator itCandCap = candidates.iterator();
        while (itCandCap.hasNext()) {
            Capability candCap = (Capability)itCandCap.next();
            boolean isFragment = Util.isFragment(candCap.getResource());
            if (isFragment) {
                if (fragmentCands == null) {
                    fragmentCands = new HashSet<Capability>();
                }
                fragmentCands.add(candCap);
            }
            if (!isFragment && (env.getWirings().containsKey(candCap.getResource()) || candCap.getResource().equals(resource))) continue;
            try {
                this.populateRevision(env, candCap.getResource());
            }
            catch (ResolutionException ex) {
                if (rethrow == null) {
                    rethrow = ex;
                }
                itCandCap.remove();
            }
        }
        if (fragmentCands != null) {
            for (Capability fragCand : fragmentCands) {
                Wiring wiring = env.getWirings().get(fragCand.getResource());
                if (wiring == null) continue;
                for (Wire wire : wiring.getRequiredResourceWires(null)) {
                    if (fragCand.getNamespace().equals("osgi.wiring.package") && !env.getWirings().get(wire.getProvider()).getResourceCapabilities(null).contains(fragCand)) continue;
                    candidates.add(new HostedCapability(wire.getCapability().getResource(), fragCand));
                }
            }
        }
        return rethrow;
    }

    public boolean isPopulated(Resource revision) {
        Object value = this.m_populateResultCache.get(revision);
        return value != null && value instanceof Boolean;
    }

    public ResolutionException getResolveException(Resource revision) {
        Object value = this.m_populateResultCache.get(revision);
        return value != null && value instanceof ResolutionException ? (ResolutionException)value : null;
    }

    private void add(Requirement req, SortedSet<Capability> candidates) {
        if (req.getNamespace().equals("osgi.wiring.host")) {
            this.m_fragmentsPresent = true;
        }
        this.m_candidateMap.put(req, candidates);
    }

    private void add(Map<Requirement, SortedSet<Capability>> candidates) {
        for (Map.Entry<Requirement, SortedSet<Capability>> entry : candidates.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public Resource getWrappedHost(Resource m) {
        Resource wrapped = this.m_allWrappedHosts.get(m);
        return wrapped == null ? m : wrapped;
    }

    public SortedSet<Capability> getCandidates(Requirement req) {
        return this.m_candidateMap.get(req);
    }

    public void prepare() {
        Map<Capability, Map<String, Map<Version, List<Requirement>>>> hostFragments = Collections.EMPTY_MAP;
        if (this.m_fragmentsPresent) {
            hostFragments = this.populateDependents();
        }
        ArrayList<HostResource> hostRevisions = new ArrayList<HostResource>();
        ArrayList<Resource> unselectedFragments = new ArrayList<Resource>();
        for (Map.Entry<Capability, Map<String, Map<Version, List<Requirement>>>> hostEntry : hostFragments.entrySet()) {
            Capability hostCap = hostEntry.getKey();
            Map<String, Map<Version, List<Requirement>>> fragments = hostEntry.getValue();
            ArrayList<Resource> selectedFragments = new ArrayList<Resource>();
            for (Map.Entry<String, Map<Version, List<Requirement>>> fragEntry : fragments.entrySet()) {
                boolean isFirst = true;
                for (Map.Entry<Version, List<Requirement>> versionEntry : fragEntry.getValue().entrySet()) {
                    for (Requirement hostReq : versionEntry.getValue()) {
                        if (isFirst) {
                            selectedFragments.add(hostReq.getResource());
                            isFirst = false;
                            continue;
                        }
                        this.m_dependentMap.get(hostCap).remove(hostReq);
                        SortedSet<Capability> hosts = this.m_candidateMap.get(hostReq);
                        hosts.remove(hostCap);
                        if (!hosts.isEmpty()) continue;
                        unselectedFragments.add(hostReq.getResource());
                    }
                }
            }
            HostResource wrappedHost = new HostResource(hostCap.getResource(), selectedFragments);
            hostRevisions.add(wrappedHost);
            this.m_allWrappedHosts.put(hostCap.getResource(), wrappedHost);
        }
        for (Resource frag : unselectedFragments) {
            this.removeRevision(frag, new ResolutionException(new StringBuffer().append("Fragment was not selected for attachment: ").append(frag).toString()));
        }
        for (HostResource hostRevision : hostRevisions) {
            for (Capability c : hostRevision.getCapabilities(null)) {
                Capability origCap;
                Set<Requirement> dependents;
                if (c.getNamespace().equals("osgi.wiring.host") || (dependents = this.m_dependentMap.get(origCap = ((HostedCapability)c).getOriginalCapability())) == null) continue;
                dependents = new HashSet<Requirement>(dependents);
                this.m_dependentMap.put(c, dependents);
                for (Requirement r : dependents) {
                    Set cands = this.m_candidateMap.get(r);
                    cands.remove(origCap);
                    cands.add(c);
                }
            }
            for (Requirement r : hostRevision.getRequirements(null)) {
                Requirement origReq = ((HostedRequirement)r).getOriginalRequirement();
                SortedSet<Capability> cands = this.m_candidateMap.get(origReq);
                if (cands == null) continue;
                this.m_candidateMap.put(r, new TreeSet<Capability>(cands));
                for (Capability cand : cands) {
                    Set<Requirement> dependents = this.m_dependentMap.get(cand);
                    dependents.remove(origReq);
                    dependents.add(r);
                }
            }
        }
        for (Resource br : this.m_mandatoryRevisions) {
            if (this.isPopulated(br)) continue;
            throw this.getResolveException(br);
        }
    }

    private Map<Capability, Map<String, Map<Version, List<Requirement>>>> populateDependents() {
        HashMap<Capability, Map<String, Map<Version, List<Requirement>>>> hostFragments = new HashMap<Capability, Map<String, Map<Version, List<Requirement>>>>();
        for (Map.Entry<Requirement, SortedSet<Capability>> entry : this.m_candidateMap.entrySet()) {
            Requirement req = entry.getKey();
            SortedSet<Capability> caps = entry.getValue();
            for (Capability cap : caps) {
                ArrayList<Requirement> actual;
                TreeMap fragmentVersions;
                Set<Requirement> dependents = this.m_dependentMap.get(cap);
                if (dependents == null) {
                    dependents = new HashSet<Requirement>();
                    this.m_dependentMap.put(cap, dependents);
                }
                dependents.add(req);
                if (!req.getNamespace().equals("osgi.wiring.host")) continue;
                String resSymName = Util.getSymbolicName(req.getResource());
                Version resVersion = Util.getVersion(req.getResource());
                HashMap fragments = (HashMap)hostFragments.get(cap);
                if (fragments == null) {
                    fragments = new HashMap();
                    hostFragments.put(cap, fragments);
                }
                if ((fragmentVersions = (TreeMap)fragments.get(resSymName)) == null) {
                    fragmentVersions = new TreeMap(Collections.reverseOrder());
                    fragments.put(resSymName, fragmentVersions);
                }
                if ((actual = (ArrayList<Requirement>)fragmentVersions.get(resVersion)) == null) {
                    actual = new ArrayList<Requirement>();
                    fragmentVersions.put(resVersion, actual);
                }
                actual.add(req);
            }
        }
        return hostFragments;
    }

    private void removeRevision(Resource revision, ResolutionException ex) {
        this.m_populateResultCache.put(revision, ex);
        HashSet<Resource> unresolvedRevisions = new HashSet<Resource>();
        this.remove(revision, unresolvedRevisions);
        while (!unresolvedRevisions.isEmpty()) {
            Iterator it = unresolvedRevisions.iterator();
            revision = (Resource)it.next();
            it.remove();
            this.remove(revision, unresolvedRevisions);
        }
    }

    private void remove(Resource resource, Set<Resource> unresolvedRevisions) throws ResolutionException {
        for (Requirement r : resource.getRequirements(null)) {
            this.remove(r);
        }
        for (Capability c : resource.getCapabilities(null)) {
            this.remove(c, unresolvedRevisions);
        }
    }

    private void remove(Requirement req) {
        boolean isFragment = req.getNamespace().equals("osgi.wiring.host");
        SortedSet<Capability> candidates = this.m_candidateMap.remove(req);
        if (candidates != null) {
            for (Capability cap : candidates) {
                Set<Requirement> dependents = this.m_dependentMap.get(cap);
                if (dependents == null) continue;
                dependents.remove(req);
            }
        }
    }

    private void remove(Capability c, Set<Resource> unresolvedRevisions) throws ResolutionException {
        Set<Requirement> dependents = this.m_dependentMap.remove(c);
        if (dependents != null) {
            for (Requirement r : dependents) {
                SortedSet<Capability> candidates = this.m_candidateMap.get(r);
                candidates.remove(c);
                if (!candidates.isEmpty()) continue;
                this.m_candidateMap.remove(r);
                if (Util.isOptional(r)) continue;
                String msg = new StringBuffer().append("Unable to resolve ").append(r.getResource()).append(": missing requirement ").append(r).toString();
                this.m_populateResultCache.put(r.getResource(), new ResolutionException(msg, null, Collections.singleton(r)));
                unresolvedRevisions.add(r.getResource());
            }
        }
    }

    public Candidates copy() {
        HashMap<Capability, Set<Requirement>> dependentMap = new HashMap<Capability, Set<Requirement>>();
        for (Map.Entry<Capability, Set<Requirement>> entry : this.m_dependentMap.entrySet()) {
            HashSet dependents = new HashSet(entry.getValue());
            dependentMap.put(entry.getKey(), dependents);
        }
        HashMap<Requirement, SortedSet<Capability>> candidateMap = new HashMap<Requirement, SortedSet<Capability>>();
        for (Map.Entry<Requirement, SortedSet<Capability>> entry : this.m_candidateMap.entrySet()) {
            TreeSet<Capability> candidates = new TreeSet<Capability>(entry.getValue());
            candidateMap.put(entry.getKey(), candidates);
        }
        return new Candidates(this.m_logger, this.m_mandatoryRevisions, dependentMap, candidateMap, this.m_allWrappedHosts, this.m_populateResultCache, this.m_fragmentsPresent);
    }

    public void dump(Environment env) {
        HashSet<Resource> resources = new HashSet<Resource>();
        for (Map.Entry<Requirement, SortedSet<Capability>> entry : this.m_candidateMap.entrySet()) {
            resources.add(entry.getKey().getResource());
        }
        this.m_logger.log(5, "=== BEGIN CANDIDATE MAP ===");
        for (Resource res : resources) {
            SortedSet<Capability> candidates;
            this.m_logger.log(5, new StringBuffer().append("  ").append(res).append(" (").append(env.getWirings().containsKey(res) ? "RESOLVED)" : "UNRESOLVED)").toString());
            List<Requirement> reqs = env.getWirings().containsKey(res) ? env.getWirings().get(res).getResourceRequirements(null) : res.getRequirements(null);
            for (Requirement req : reqs) {
                candidates = this.m_candidateMap.get(req);
                if (candidates == null || candidates.size() <= 0) continue;
                this.m_logger.log(5, new StringBuffer().append("    ").append(req).append(": ").append(candidates).toString());
            }
            reqs = env.getWirings().containsKey(res) ? Util.getDynamicRequirements(env.getWirings().get(res).getResourceRequirements(null)) : Util.getDynamicRequirements(res.getRequirements(null));
            for (Requirement req : reqs) {
                candidates = this.m_candidateMap.get(req);
                if (candidates == null || candidates.size() <= 0) continue;
                this.m_logger.log(5, new StringBuffer().append("    ").append(req).append(": ").append(candidates).toString());
            }
        }
        this.m_logger.log(5, "=== END CANDIDATE MAP ===");
    }
}

