/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.i18n;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.felix.webconsole.internal.i18n.ConsolePropertyResourceBundle;
import org.osgi.framework.Bundle;

public class ResourceBundleCache {
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private final Bundle bundle;
    private final Map resourceBundles;
    private Map resourceBundleEntries;

    public ResourceBundleCache(Bundle bundle) {
        this.bundle = bundle;
        this.resourceBundles = new HashMap();
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            return this.getResourceBundleInternal(DEFAULT_LOCALE);
        }
        return this.getResourceBundleInternal(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceBundle getResourceBundleInternal(Locale locale) {
        ResourceBundle bundle;
        if (locale == null) {
            return null;
        }
        Map map = this.resourceBundles;
        synchronized (map) {
            bundle = (ResourceBundle)this.resourceBundles.get(locale);
            if (bundle != null) {
                return bundle;
            }
        }
        ResourceBundle parent = this.getResourceBundleInternal(ResourceBundleCache.getParentLocale(locale));
        bundle = this.loadResourceBundle(parent, locale);
        Map map2 = this.resourceBundles;
        synchronized (map2) {
            this.resourceBundles.put(locale, bundle);
        }
        return bundle;
    }

    private ResourceBundle loadResourceBundle(ResourceBundle parent, Locale locale) {
        String path = "_" + locale.toString();
        URL source = (URL)this.getResourceBundleEntries().get(path);
        return new ConsolePropertyResourceBundle(parent, source);
    }

    private synchronized Map getResourceBundleEntries() {
        if (this.resourceBundleEntries == null) {
            String file = (String)this.bundle.getHeaders().get("Bundle-Localization");
            if (file == null) {
                file = "OSGI-INF/l10n/bundle";
            }
            if (file.startsWith("/")) {
                file = file.substring(1);
            }
            int slash = file.lastIndexOf(47);
            String fileName = file.substring(slash + 1);
            String path = slash <= 0 ? "/" : file.substring(0, slash);
            HashMap<String, URL> resourceBundleEntries = new HashMap<String, URL>();
            Enumeration locales = this.bundle.findEntries(path, fileName + "*.properties", false);
            if (locales != null) {
                while (locales.hasMoreElements()) {
                    int end;
                    URL entry = (URL)locales.nextElement();
                    String entryPath = entry.getPath();
                    int start = entryPath.lastIndexOf(47) + 1 + fileName.length();
                    if ((entryPath = entryPath.substring(start, end = entryPath.length() - 11)).length() == 0) {
                        entryPath = "_" + DEFAULT_LOCALE;
                    }
                    if (resourceBundleEntries.containsKey(entryPath)) continue;
                    resourceBundleEntries.put(entryPath, entry);
                }
            }
            this.resourceBundleEntries = resourceBundleEntries;
        }
        return this.resourceBundleEntries;
    }

    private static final Locale getParentLocale(Locale locale) {
        if (locale.getVariant().length() != 0) {
            return new Locale(locale.getLanguage(), locale.getCountry());
        }
        if (locale.getCountry().length() != 0) {
            return new Locale(locale.getLanguage(), "");
        }
        if (!locale.getLanguage().equals(DEFAULT_LOCALE.getLanguage())) {
            return DEFAULT_LOCALE;
        }
        return null;
    }
}

