/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.formats.avro.AvroSerializationSchema;
import org.apache.flink.formats.avro.SchemaCoder;
import org.apache.flink.util.WrappingRuntimeException;

public class RegistryAvroSerializationSchema<T>
extends AvroSerializationSchema<T> {
    private static final long serialVersionUID = -6766681879020862312L;
    private final SchemaCoder.SchemaCoderProvider schemaCoderProvider;
    protected SchemaCoder schemaCoder;

    public RegistryAvroSerializationSchema(Class<T> recordClazz, Schema schema, SchemaCoder.SchemaCoderProvider schemaCoderProvider) {
        super(recordClazz, schema);
        this.schemaCoderProvider = schemaCoderProvider;
    }

    public static <T extends SpecificRecord> RegistryAvroSerializationSchema<T> forSpecific(Class<T> tClass, SchemaCoder.SchemaCoderProvider schemaCoderProvider) {
        return new RegistryAvroSerializationSchema<T>(tClass, null, schemaCoderProvider);
    }

    public static RegistryAvroSerializationSchema<GenericRecord> forGeneric(Schema schema, SchemaCoder.SchemaCoderProvider schemaCoderProvider) {
        return new RegistryAvroSerializationSchema<GenericRecord>(GenericRecord.class, schema, schemaCoderProvider);
    }

    @Override
    public byte[] serialize(T object) {
        this.checkAvroInitialized();
        if (object == null) {
            return null;
        }
        try {
            ByteArrayOutputStream outputStream = this.getOutputStream();
            outputStream.reset();
            BinaryEncoder encoder = this.getEncoder();
            this.schemaCoder.writeSchema(this.getSchema(), outputStream);
            this.getDatumWriter().write(object, (Encoder)encoder);
            encoder.flush();
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new WrappingRuntimeException("Failed to serialize schema registry.", (Throwable)e);
        }
    }

    @Override
    protected void checkAvroInitialized() {
        super.checkAvroInitialized();
        if (this.schemaCoder == null) {
            this.schemaCoder = this.schemaCoderProvider.get();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegistryAvroSerializationSchema that = (RegistryAvroSerializationSchema)o;
        return this.schemaCoderProvider.equals(that.schemaCoderProvider);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.schemaCoderProvider);
    }
}

