/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.CheckpointType;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.concurrent.FutureUtils;

public interface ClusterClient<T>
extends AutoCloseable {
    @Override
    public void close();

    public T getClusterId();

    public Configuration getFlinkConfiguration();

    public void shutDownCluster();

    public String getWebInterfaceURL();

    public CompletableFuture<Collection<JobStatusMessage>> listJobs() throws Exception;

    public CompletableFuture<Acknowledge> disposeSavepoint(String var1) throws FlinkException;

    public CompletableFuture<JobID> submitJob(JobGraph var1);

    public CompletableFuture<JobStatus> getJobStatus(JobID var1);

    public CompletableFuture<JobResult> requestJobResult(JobID var1);

    default public CompletableFuture<Map<String, Object>> getAccumulators(JobID jobID) {
        return this.getAccumulators(jobID, ClassLoader.getSystemClassLoader());
    }

    public CompletableFuture<Map<String, Object>> getAccumulators(JobID var1, ClassLoader var2);

    public CompletableFuture<Acknowledge> cancel(JobID var1);

    public CompletableFuture<String> cancelWithSavepoint(JobID var1, @Nullable String var2, SavepointFormatType var3);

    public CompletableFuture<String> stopWithSavepoint(JobID var1, boolean var2, @Nullable String var3, SavepointFormatType var4);

    public CompletableFuture<String> stopWithDetachedSavepoint(JobID var1, boolean var2, @Nullable String var3, SavepointFormatType var4);

    public CompletableFuture<String> triggerSavepoint(JobID var1, @Nullable String var2, SavepointFormatType var3);

    public CompletableFuture<Long> triggerCheckpoint(JobID var1, CheckpointType var2);

    public CompletableFuture<String> triggerDetachedSavepoint(JobID var1, @Nullable String var2, SavepointFormatType var3);

    public CompletableFuture<CoordinationResponse> sendCoordinationRequest(JobID var1, String var2, CoordinationRequest var3);

    default public CompletableFuture<Set<AbstractID>> listCompletedClusterDatasetIds() {
        return CompletableFuture.completedFuture(Collections.emptySet());
    }

    default public CompletableFuture<Void> invalidateClusterDataset(AbstractID clusterDatasetId) {
        return CompletableFuture.completedFuture(null);
    }

    default public CompletableFuture<Void> reportHeartbeat(JobID jobId, long expiredTimestamp) {
        return FutureUtils.completedVoidFuture();
    }
}

