/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.util.concurrent.ScheduledExecutor;

class JobStatusPollingUtils {
    JobStatusPollingUtils() {
    }

    static CompletableFuture<JobResult> getJobResult(DispatcherGateway dispatcherGateway, JobID jobId, ScheduledExecutor scheduledExecutor, Duration rpcTimeout, Duration retryPeriod) {
        return JobStatusPollingUtils.pollJobResultAsync(() -> dispatcherGateway.requestJobStatus(jobId, rpcTimeout), () -> dispatcherGateway.requestJobResult(jobId, rpcTimeout), scheduledExecutor, retryPeriod.toMillis());
    }

    @VisibleForTesting
    static CompletableFuture<JobResult> pollJobResultAsync(Supplier<CompletableFuture<JobStatus>> jobStatusSupplier, Supplier<CompletableFuture<JobResult>> jobResultSupplier, ScheduledExecutor scheduledExecutor, long retryMsTimeout) {
        return JobStatusPollingUtils.pollJobResultAsync(jobStatusSupplier, jobResultSupplier, scheduledExecutor, new CompletableFuture<JobResult>(), retryMsTimeout, 0L);
    }

    private static CompletableFuture<JobResult> pollJobResultAsync(Supplier<CompletableFuture<JobStatus>> jobStatusSupplier, Supplier<CompletableFuture<JobResult>> jobResultSupplier, ScheduledExecutor scheduledExecutor, CompletableFuture<JobResult> resultFuture, long retryMsTimeout, long attempt) {
        jobStatusSupplier.get().whenComplete((jobStatus, throwable) -> {
            if (throwable != null) {
                resultFuture.completeExceptionally((Throwable)throwable);
            } else if (jobStatus.isGloballyTerminalState()) {
                ((CompletableFuture)jobResultSupplier.get()).whenComplete((jobResult, t) -> {
                    if (t != null) {
                        resultFuture.completeExceptionally((Throwable)t);
                    } else {
                        resultFuture.complete((JobResult)jobResult);
                    }
                });
            } else {
                scheduledExecutor.schedule(() -> JobStatusPollingUtils.lambda$pollJobResultAsync$3((Supplier)jobStatusSupplier, (Supplier)jobResultSupplier, scheduledExecutor, resultFuture, retryMsTimeout, attempt), retryMsTimeout, TimeUnit.MILLISECONDS);
            }
        });
        return resultFuture;
    }

    private static /* synthetic */ void lambda$pollJobResultAsync$3(Supplier jobStatusSupplier, Supplier jobResultSupplier, ScheduledExecutor scheduledExecutor, CompletableFuture resultFuture, long retryMsTimeout, long attempt) {
        JobStatusPollingUtils.pollJobResultAsync(jobStatusSupplier, jobResultSupplier, scheduledExecutor, resultFuture, retryMsTimeout, attempt + 1L);
    }
}

