/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.clusterframework.messages.GetClusterStatus;
import org.apache.flink.runtime.clusterframework.messages.GetClusterStatusResponse;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.jobgraph.JobGraph;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public class StandaloneClusterClient
extends ClusterClient {
    public StandaloneClusterClient(Configuration config) throws IOException {
        super(config);
    }

    @Override
    public String getWebInterfaceURL() {
        String host = this.getJobManagerAddressFromConfig().getHostString();
        int port = this.getFlinkConfiguration().getInteger("jobmanager.web.port", 8081);
        return "http://" + host + ":" + port;
    }

    @Override
    public GetClusterStatusResponse getClusterStatus() {
        try {
            ActorGateway jmGateway = this.getJobManagerGateway();
            Future future = jmGateway.ask((Object)GetClusterStatus.getInstance(), this.timeout);
            Object result = Await.result((Awaitable)future, (Duration)this.timeout);
            if (result instanceof GetClusterStatusResponse) {
                return (GetClusterStatusResponse)result;
            }
            throw new RuntimeException("Received the wrong reply " + result + " from cluster.");
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't retrieve the Cluster status.", e);
        }
    }

    @Override
    public List<String> getNewMessages() {
        return Collections.emptyList();
    }

    @Override
    public String getClusterIdentifier() {
        return "Standalone cluster with JobManager at " + this.getJobManagerAddressFromConfig();
    }

    @Override
    public int getMaxSlots() {
        return -1;
    }

    @Override
    protected JobSubmissionResult submitJob(JobGraph jobGraph, ClassLoader classLoader) throws ProgramInvocationException {
        if (this.isDetached()) {
            return super.runDetached(jobGraph, classLoader);
        }
        return super.run(jobGraph, classLoader);
    }

    @Override
    protected void finalizeCluster() {
    }
}

