/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.mysql.database.dialect;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.core.database.dialect.AbstractDialect;
import org.apache.flink.connector.jdbc.core.database.dialect.JdbcDialectConverter;
import org.apache.flink.connector.jdbc.mysql.database.dialect.MySQLDialectConverter;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class MySqlDialect
extends AbstractDialect {
    private static final long serialVersionUID = 1L;
    private static final int MAX_TIMESTAMP_PRECISION = 6;
    private static final int MIN_TIMESTAMP_PRECISION = 0;
    private static final int MAX_DECIMAL_PRECISION = 65;
    private static final int MIN_DECIMAL_PRECISION = 1;
    private static final String REWRITE_BATCHED_STATEMENTS = "rewriteBatchedStatements";

    public JdbcDialectConverter getRowConverter(RowType rowType) {
        return new MySQLDialectConverter(rowType);
    }

    public String getLimitClause(long limit) {
        return "LIMIT " + limit;
    }

    public Optional<String> defaultDriverName() {
        return Optional.of("com.mysql.jdbc.Driver");
    }

    public String quoteIdentifier(String identifier) {
        return "`" + identifier + "`";
    }

    public Optional<String> getUpsertStatement(String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        String updateClause = Arrays.stream(fieldNames).map(f -> this.quoteIdentifier((String)f) + "=VALUES(" + this.quoteIdentifier((String)f) + ")").collect(Collectors.joining(", "));
        return Optional.of(this.getInsertIntoStatement(tableName, fieldNames) + " ON DUPLICATE KEY UPDATE " + updateClause);
    }

    public String dialectName() {
        return "MySQL";
    }

    public Optional<AbstractDialect.Range> decimalPrecisionRange() {
        return Optional.of(AbstractDialect.Range.of((int)1, (int)65));
    }

    public Optional<AbstractDialect.Range> timestampPrecisionRange() {
        return Optional.of(AbstractDialect.Range.of((int)0, (int)6));
    }

    public Set<LogicalTypeRoot> supportedTypes() {
        return EnumSet.of(LogicalTypeRoot.CHAR, new LogicalTypeRoot[]{LogicalTypeRoot.VARCHAR, LogicalTypeRoot.BOOLEAN, LogicalTypeRoot.VARBINARY, LogicalTypeRoot.DECIMAL, LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.INTEGER, LogicalTypeRoot.BIGINT, LogicalTypeRoot.FLOAT, LogicalTypeRoot.DOUBLE, LogicalTypeRoot.DATE, LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE});
    }

    public String appendDefaultUrlProperties(String url) {
        if (!url.contains(REWRITE_BATCHED_STATEMENTS)) {
            String defaultUrlProperties = "rewriteBatchedStatements=true";
            if (url.contains("?")) {
                return url + "&" + defaultUrlProperties;
            }
            return url + "?" + defaultUrlProperties;
        }
        return url;
    }
}

