/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.oracle.database.dialect;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.core.database.dialect.AbstractDialect;
import org.apache.flink.connector.jdbc.core.database.dialect.JdbcDialectConverter;
import org.apache.flink.connector.jdbc.oracle.database.dialect.OracleDialectConverter;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class OracleDialect
extends AbstractDialect {
    private static final long serialVersionUID = 1L;
    private static final int MAX_TIMESTAMP_PRECISION = 9;
    private static final int MIN_TIMESTAMP_PRECISION = 1;
    private static final int MAX_DECIMAL_PRECISION = 38;
    private static final int MIN_DECIMAL_PRECISION = 1;

    public JdbcDialectConverter getRowConverter(RowType rowType) {
        return new OracleDialectConverter(rowType);
    }

    public String getLimitClause(long limit) {
        return "FETCH FIRST " + limit + " ROWS ONLY";
    }

    public Optional<String> defaultDriverName() {
        return Optional.of("oracle.jdbc.OracleDriver");
    }

    public String dialectName() {
        return "Oracle";
    }

    public String quoteIdentifier(String identifier) {
        return identifier;
    }

    public Optional<String> getUpsertStatement(String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        String sourceFields = Arrays.stream(fieldNames).map(f -> ":" + f + " " + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        String onClause = Arrays.stream(uniqueKeyFields).map(f -> "t." + this.quoteIdentifier((String)f) + "=s." + this.quoteIdentifier((String)f)).collect(Collectors.joining(" and "));
        Set uniqueKeyFieldsSet = Arrays.stream(uniqueKeyFields).collect(Collectors.toSet());
        String updateClause = Arrays.stream(fieldNames).filter(f -> !uniqueKeyFieldsSet.contains(f)).map(f -> "t." + this.quoteIdentifier((String)f) + "=s." + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        String insertFields = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String valuesClause = Arrays.stream(fieldNames).map(f -> "s." + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        String mergeQuery = " MERGE INTO " + tableName + " t  USING (SELECT " + sourceFields + " FROM DUAL) s  ON (" + onClause + ")  WHEN MATCHED THEN UPDATE SET " + updateClause + " WHEN NOT MATCHED THEN INSERT (" + insertFields + ") VALUES (" + valuesClause + ")";
        return Optional.of(mergeQuery);
    }

    public Optional<AbstractDialect.Range> decimalPrecisionRange() {
        return Optional.of(AbstractDialect.Range.of((int)1, (int)38));
    }

    public Optional<AbstractDialect.Range> timestampPrecisionRange() {
        return Optional.of(AbstractDialect.Range.of((int)1, (int)9));
    }

    public Set<LogicalTypeRoot> supportedTypes() {
        return EnumSet.of(LogicalTypeRoot.CHAR, new LogicalTypeRoot[]{LogicalTypeRoot.VARCHAR, LogicalTypeRoot.BOOLEAN, LogicalTypeRoot.VARBINARY, LogicalTypeRoot.DECIMAL, LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.INTEGER, LogicalTypeRoot.BIGINT, LogicalTypeRoot.FLOAT, LogicalTypeRoot.DOUBLE, LogicalTypeRoot.DATE, LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, LogicalTypeRoot.ARRAY});
    }
}

