/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.oracle.database.dialect;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleClob;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.CHAR;
import oracle.sql.DATE;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.core.database.dialect.AbstractDialectConverter;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class OracleDialectConverter
extends AbstractDialectConverter {
    private static final long serialVersionUID = 1L;

    public OracleDialectConverter(RowType rowType) {
        super(rowType);
    }

    public AbstractDialectConverter.JdbcDeserializationConverter createInternalConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> null;
            }
            case BOOLEAN: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof NUMBER ? Boolean.valueOf(((NUMBER)val).booleanValue()) : val;
            }
            case FLOAT: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof NUMBER ? Float.valueOf(((NUMBER)val).floatValue()) : (val instanceof BINARY_FLOAT ? Float.valueOf(((BINARY_FLOAT)val).floatValue()) : (val instanceof BigDecimal ? Float.valueOf(((BigDecimal)val).floatValue()) : val));
            }
            case DOUBLE: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof NUMBER ? Double.valueOf(((NUMBER)val).doubleValue()) : (val instanceof BINARY_DOUBLE ? Double.valueOf(((BINARY_DOUBLE)val).doubleValue()) : (val instanceof BigDecimal ? Double.valueOf(((BigDecimal)val).doubleValue()) : val));
            }
            case TINYINT: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof NUMBER ? Byte.valueOf(((NUMBER)val).byteValue()) : (val instanceof BigDecimal ? Byte.valueOf(((BigDecimal)val).byteValue()) : val);
            }
            case SMALLINT: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof NUMBER ? Short.valueOf(((NUMBER)val).shortValue()) : (val instanceof BigDecimal ? Short.valueOf(((BigDecimal)val).shortValue()) : val);
            }
            case INTEGER: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof NUMBER ? Integer.valueOf(((NUMBER)val).intValue()) : (val instanceof BigDecimal ? Integer.valueOf(((BigDecimal)val).intValue()) : val);
            }
            case BIGINT: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof NUMBER ? Long.valueOf(((NUMBER)val).longValue()) : (val instanceof BigDecimal ? Long.valueOf(((BigDecimal)val).longValue()) : val);
            }
            case DECIMAL: {
                int precision = ((DecimalType)type).getPrecision();
                int scale = ((DecimalType)type).getScale();
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof BigInteger ? DecimalData.fromBigDecimal((BigDecimal)new BigDecimal((BigInteger)val, 0), (int)precision, (int)scale) : DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)val), (int)precision, (int)scale);
            }
            case CHAR: 
            case VARCHAR: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof CHAR ? StringData.fromString((String)((CHAR)val).getString()) : (val instanceof OracleClob ? StringData.fromString((String)((OracleClob)val).stringValue()) : StringData.fromString((String)((String)val)));
            }
            case BINARY: 
            case VARBINARY: 
            case RAW: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof RAW ? ((RAW)val).getBytes() : (val instanceof OracleBlob ? ((OracleBlob)val).getBytes(1L, (int)((OracleBlob)val).length()) : val.toString().getBytes());
            }
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof NUMBER ? Integer.valueOf(((NUMBER)val).intValue()) : val;
            }
            case DATE: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof DATE ? (int)((DATE)val).dateValue().toLocalDate().toEpochDay() : (val instanceof Timestamp ? (int)((Timestamp)val).toLocalDateTime().toLocalDate().toEpochDay() : (int)((Date)val).toLocalDate().toEpochDay());
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof DATE ? (int)(((DATE)val).timeValue().toLocalTime().toNanoOfDay() / 1000000L) : (int)(((Time)val).toLocalTime().toNanoOfDay() / 1000000L);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> val instanceof TIMESTAMP ? TimestampData.fromTimestamp((Timestamp)((TIMESTAMP)val).timestampValue()) : TimestampData.fromTimestamp((Timestamp)((Timestamp)val));
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> {
                    if (val instanceof TIMESTAMPTZ) {
                        TIMESTAMPTZ ts = (TIMESTAMPTZ)val;
                        ZonedDateTime zdt = ZonedDateTime.ofInstant(ts.timestampValue().toInstant(), ts.getTimeZone().toZoneId());
                        return TimestampData.fromLocalDateTime((LocalDateTime)zdt.toLocalDateTime());
                    }
                    return TimestampData.fromTimestamp((Timestamp)((Timestamp)val));
                };
            }
        }
        return super.createInternalConverter(type);
    }

    public String converterName() {
        return "Oracle";
    }
}

