/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.postgres.database.dialect;

import java.io.Serializable;
import java.lang.reflect.Array;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.core.database.dialect.AbstractDialectConverter;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;

@Internal
public class PostgresDialectConverter
extends AbstractDialectConverter {
    private static final long serialVersionUID = 1L;

    protected PostgresDialectConverter(RowType rowType) {
        super(rowType);
    }

    public AbstractDialectConverter.JdbcDeserializationConverter createInternalConverter(LogicalType type) {
        LogicalTypeRoot root = type.getTypeRoot();
        if (root == LogicalTypeRoot.ARRAY) {
            ArrayType arrayType = (ArrayType)type;
            return this.createPostgresArrayConverter(arrayType);
        }
        return this.createPrimitiveConverter(type);
    }

    protected AbstractDialectConverter.JdbcSerializationConverter createNullableExternalConverter(LogicalType type) {
        LogicalTypeRoot root = type.getTypeRoot();
        if (root == LogicalTypeRoot.ARRAY) {
            return (AbstractDialectConverter.JdbcSerializationConverter & Serializable)(val, index, statement) -> {
                throw new IllegalStateException(String.format("Writing ARRAY type is not yet supported in JDBC:%s.", this.converterName()));
            };
        }
        return super.createNullableExternalConverter(type);
    }

    private AbstractDialectConverter.JdbcDeserializationConverter createPostgresArrayConverter(ArrayType arrayType) {
        Class elementClass = LogicalTypeUtils.toInternalConversionClass((LogicalType)arrayType.getElementType());
        AbstractDialectConverter.JdbcDeserializationConverter elementConverter = this.createNullableInternalConverter(arrayType.getElementType());
        return (AbstractDialectConverter.JdbcDeserializationConverter & Serializable)val -> {
            java.sql.Array pgArray = (java.sql.Array)val;
            Object[] in = (Object[])pgArray.getArray();
            Object[] array = (Object[])Array.newInstance(elementClass, in.length);
            for (int i = 0; i < in.length; ++i) {
                array[i] = elementConverter.deserialize(in[i]);
            }
            return new GenericArrayData(array);
        };
    }

    private AbstractDialectConverter.JdbcDeserializationConverter createPrimitiveConverter(LogicalType type) {
        return super.createInternalConverter(type);
    }

    public String converterName() {
        return "PostgreSQL";
    }
}

