/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.databases.db2.dialect;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.connector.jdbc.converter.JdbcRowConverter;
import org.apache.flink.connector.jdbc.databases.db2.dialect.Db2RowConverter;
import org.apache.flink.connector.jdbc.dialect.AbstractDialect;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

public class Db2Dialect
extends AbstractDialect {
    private static final long serialVersionUID = 1L;
    private static final int MAX_TIMESTAMP_PRECISION = 9;
    private static final int MIN_TIMESTAMP_PRECISION = 1;
    private static final int MAX_DECIMAL_PRECISION = 31;
    private static final int MIN_DECIMAL_PRECISION = 1;

    @Override
    public JdbcRowConverter getRowConverter(RowType rowType) {
        return new Db2RowConverter(rowType);
    }

    @Override
    public Optional<String> defaultDriverName() {
        return Optional.of("com.ibm.db2.jcc.DB2Driver");
    }

    @Override
    public String quoteIdentifier(String identifier) {
        return identifier;
    }

    @Override
    public String dialectName() {
        return "Db2";
    }

    @Override
    public String getLimitClause(long limit) {
        return String.format("FETCH FIRST %d ROWS ONLY", limit);
    }

    @Override
    public Optional<String> getUpsertStatement(String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        List nonUniqueKeyFields = Arrays.stream(fieldNames).filter(f -> !Arrays.asList(uniqueKeyFields).contains(f)).collect(Collectors.toList());
        String fieldsProjection = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String valuesBinding = Arrays.stream(fieldNames).map(f -> ":" + f).collect(Collectors.joining(", "));
        String columnBinding = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String onConditions = Arrays.stream(uniqueKeyFields).map(f -> "TARGET." + this.quoteIdentifier((String)f) + "= SOURCE." + this.quoteIdentifier((String)f)).collect(Collectors.joining(" AND "));
        String updateSetClause = nonUniqueKeyFields.stream().map(f -> "TARGET." + this.quoteIdentifier((String)f) + "= SOURCE." + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        String insertValues = Arrays.stream(fieldNames).map(f -> "SOURCE." + this.quoteIdentifier((String)f)).collect(Collectors.joining(", "));
        Optional<String> format = Optional.of(String.format("MERGE INTO %s AS TARGET USING TABLE (VALUES ( %s )) AS SOURCE ( %s ) ON (%s) WHEN MATCHED THEN UPDATE SET %s WHEN NOT MATCHED THEN INSERT (%s) VALUES (%s);", this.quoteIdentifier(tableName), valuesBinding, columnBinding, onConditions, updateSetClause, fieldsProjection, insertValues));
        return format;
    }

    @Override
    public Optional<AbstractDialect.Range> decimalPrecisionRange() {
        return Optional.of(AbstractDialect.Range.of(1, 31));
    }

    @Override
    public Optional<AbstractDialect.Range> timestampPrecisionRange() {
        return Optional.of(AbstractDialect.Range.of(1, 9));
    }

    @Override
    public Set<LogicalTypeRoot> supportedTypes() {
        return EnumSet.of(LogicalTypeRoot.CHAR, new LogicalTypeRoot[]{LogicalTypeRoot.VARCHAR, LogicalTypeRoot.BOOLEAN, LogicalTypeRoot.VARBINARY, LogicalTypeRoot.DECIMAL, LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.INTEGER, LogicalTypeRoot.BIGINT, LogicalTypeRoot.FLOAT, LogicalTypeRoot.DOUBLE, LogicalTypeRoot.DATE, LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE});
    }
}

