/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.options;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.dialect.JdbcDialectLoader;
import org.apache.flink.util.Preconditions;

@Internal
public class InternalJdbcConnectionOptions
extends JdbcConnectionOptions {
    private static final long serialVersionUID = 1L;
    private final String tableName;
    private final JdbcDialect dialect;
    @Nullable
    private final Integer parallelism;

    private InternalJdbcConnectionOptions(String dbURL, String tableName, @Nullable String driverName, @Nullable String username, @Nullable String password, JdbcDialect dialect, @Nullable Integer parallelism, int connectionCheckTimeoutSeconds) {
        super(dbURL, driverName, username, password, connectionCheckTimeoutSeconds);
        this.tableName = tableName;
        this.dialect = dialect;
        this.parallelism = parallelism;
    }

    public String getTableName() {
        return this.tableName;
    }

    public JdbcDialect getDialect() {
        return this.dialect;
    }

    public Integer getParallelism() {
        return this.parallelism;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o instanceof InternalJdbcConnectionOptions) {
            InternalJdbcConnectionOptions options = (InternalJdbcConnectionOptions)o;
            return Objects.equals(this.url, options.url) && Objects.equals(this.tableName, options.tableName) && Objects.equals(this.driverName, options.driverName) && Objects.equals(this.username, options.username) && Objects.equals(this.password, options.password) && Objects.equals(this.dialect.getClass().getName(), options.dialect.getClass().getName()) && Objects.equals(this.parallelism, options.parallelism) && Objects.equals(this.connectionCheckTimeoutSeconds, options.connectionCheckTimeoutSeconds);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.url, this.tableName, this.driverName, this.username, this.password, this.dialect.getClass().getName(), this.parallelism, this.connectionCheckTimeoutSeconds);
    }

    public static class Builder {
        private ClassLoader classLoader;
        private String dbURL;
        private String tableName;
        private String driverName;
        private String compatibleMode;
        private String username;
        private String password;
        private JdbcDialect dialect;
        private Integer parallelism;
        private int connectionCheckTimeoutSeconds = 60;

        public Builder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setConnectionCheckTimeoutSeconds(int connectionCheckTimeoutSeconds) {
            this.connectionCheckTimeoutSeconds = connectionCheckTimeoutSeconds;
            return this;
        }

        public Builder setDriverName(String driverName) {
            this.driverName = driverName;
            return this;
        }

        public Builder setCompatibleMode(String compatibleMode) {
            this.compatibleMode = compatibleMode;
            return this;
        }

        public Builder setDBUrl(String dbURL) {
            this.dbURL = dbURL;
            return this;
        }

        public Builder setDialect(JdbcDialect dialect) {
            this.dialect = dialect;
            return this;
        }

        public Builder setParallelism(Integer parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public InternalJdbcConnectionOptions build() {
            Preconditions.checkNotNull((Object)this.dbURL, (String)"No dbURL supplied.");
            Preconditions.checkNotNull((Object)this.tableName, (String)"No tableName supplied.");
            if (this.dialect == null) {
                if (this.classLoader == null) {
                    this.classLoader = Thread.currentThread().getContextClassLoader();
                }
                this.dialect = JdbcDialectLoader.load(this.dbURL, this.compatibleMode, this.classLoader);
            }
            if (this.driverName == null) {
                Optional<String> optional = this.dialect.defaultDriverName();
                this.driverName = optional.orElseThrow(() -> new NullPointerException("No driverName supplied."));
            }
            return new InternalJdbcConnectionOptions(this.dialect.appendDefaultUrlProperties(this.dbURL), this.tableName, this.driverName, this.username, this.password, this.dialect, this.parallelism, this.connectionCheckTimeoutSeconds);
        }
    }
}

