/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.source;

import javax.annotation.Nonnull;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.datasource.connections.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.datasource.connections.SimpleJdbcConnectionProvider;
import org.apache.flink.connector.jdbc.source.JdbcSource;
import org.apache.flink.connector.jdbc.source.JdbcSourceOptions;
import org.apache.flink.connector.jdbc.source.enumerator.SqlTemplateSplitEnumerator;
import org.apache.flink.connector.jdbc.source.reader.extractor.ResultExtractor;
import org.apache.flink.connector.jdbc.split.JdbcParameterValuesProvider;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class JdbcSourceBuilder<OUT> {
    public static final Logger LOG = LoggerFactory.getLogger(JdbcSourceBuilder.class);
    private final Configuration configuration = new Configuration();
    private int splitReaderFetchBatchSize;
    private int resultSetType;
    private int resultSetConcurrency;
    private int resultSetFetchSize;
    private Boolean autoCommit = true;
    private DeliveryGuarantee deliveryGuarantee;
    private TypeInformation<OUT> typeInformation;
    private final JdbcConnectionOptions.JdbcConnectionOptionsBuilder connOptionsBuilder = new JdbcConnectionOptions.JdbcConnectionOptionsBuilder();
    private String sql;
    private JdbcParameterValuesProvider jdbcParameterValuesProvider;
    private ResultExtractor<OUT> resultExtractor;
    private JdbcConnectionProvider connectionProvider;

    JdbcSourceBuilder() {
        this.splitReaderFetchBatchSize = (Integer)JdbcSourceOptions.READER_FETCH_BATCH_SIZE.defaultValue();
        this.resultSetType = (Integer)JdbcSourceOptions.RESULTSET_TYPE.defaultValue();
        this.resultSetConcurrency = (Integer)JdbcSourceOptions.RESULTSET_CONCURRENCY.defaultValue();
        this.deliveryGuarantee = DeliveryGuarantee.NONE;
    }

    public JdbcSourceBuilder<OUT> setSql(@Nonnull String sql) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)sql) ? 1 : 0) != 0, (Object)"It's required to set the 'sql' with non-empty value.");
        this.sql = sql;
        return this;
    }

    public JdbcSourceBuilder<OUT> setResultExtractor(ResultExtractor<OUT> resultExtractor) {
        this.resultExtractor = (ResultExtractor)Preconditions.checkNotNull(resultExtractor, (String)"It's required to set the 'resultExtractor'.");
        return this;
    }

    public JdbcSourceBuilder<OUT> setUsername(String username) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)username) ? 1 : 0) != 0, (Object)"It's required to set the 'username'.");
        this.connOptionsBuilder.withUsername(username);
        return this;
    }

    public JdbcSourceBuilder<OUT> setPassword(String password) {
        this.connOptionsBuilder.withPassword(password);
        return this;
    }

    public JdbcSourceBuilder<OUT> setDriverName(String driverName) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)driverName) ? 1 : 0) != 0, (Object)"It's required to set the 'driverName'.");
        this.connOptionsBuilder.withDriverName(driverName);
        return this;
    }

    public JdbcSourceBuilder<OUT> setDBUrl(String dbURL) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)dbURL) ? 1 : 0) != 0, (Object)"It's required to set the 'dbURL'.");
        this.connOptionsBuilder.withUrl(dbURL);
        return this;
    }

    public JdbcSourceBuilder<OUT> setTypeInformation(@Nonnull TypeInformation<OUT> typeInformation) {
        this.typeInformation = (TypeInformation)Preconditions.checkNotNull(typeInformation, (String)"It's required to set the 'typeInformation'.");
        return this;
    }

    public JdbcSourceBuilder<OUT> setJdbcParameterValuesProvider(@Nonnull JdbcParameterValuesProvider parameterValuesProvider) {
        this.jdbcParameterValuesProvider = (JdbcParameterValuesProvider)Preconditions.checkNotNull((Object)parameterValuesProvider);
        return this;
    }

    public JdbcSourceBuilder<OUT> setSplitReaderFetchBatchSize(int splitReaderFetchBatchSize) {
        Preconditions.checkArgument((splitReaderFetchBatchSize > 0 ? 1 : 0) != 0, (String)"'splitReaderFetchBatchSize' must be in range (0, %s]", (Object[])new Object[]{Integer.MAX_VALUE});
        this.splitReaderFetchBatchSize = splitReaderFetchBatchSize;
        return this;
    }

    public JdbcSourceBuilder<OUT> setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
        return this;
    }

    public JdbcSourceBuilder<OUT> setResultSetConcurrency(int resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
        return this;
    }

    public JdbcSourceBuilder<OUT> setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
        return this;
    }

    public JdbcSourceBuilder<OUT> setResultSetFetchSize(int resultSetFetchSize) {
        Preconditions.checkArgument((resultSetFetchSize == Integer.MIN_VALUE || resultSetFetchSize > 0 ? 1 : 0) != 0, (String)"Illegal value %s for fetchSize, has to be positive or Integer.MIN_VALUE.", (Object[])new Object[]{resultSetFetchSize});
        this.resultSetFetchSize = resultSetFetchSize;
        return this;
    }

    public JdbcSourceBuilder<OUT> setConnectionProvider(@Nonnull JdbcConnectionProvider connectionProvider) {
        this.connectionProvider = (JdbcConnectionProvider)Preconditions.checkNotNull((Object)connectionProvider);
        return this;
    }

    public JdbcSource<OUT> build() {
        this.connectionProvider = new SimpleJdbcConnectionProvider(this.connOptionsBuilder.build());
        if (this.resultSetFetchSize > 0) {
            this.configuration.set(JdbcSourceOptions.RESULTSET_FETCH_SIZE, (Object)this.resultSetFetchSize);
        }
        this.configuration.set(JdbcSourceOptions.RESULTSET_CONCURRENCY, (Object)this.resultSetConcurrency);
        this.configuration.set(JdbcSourceOptions.RESULTSET_TYPE, (Object)this.resultSetType);
        this.configuration.set(JdbcSourceOptions.READER_FETCH_BATCH_SIZE, (Object)this.splitReaderFetchBatchSize);
        this.configuration.set(JdbcSourceOptions.AUTO_COMMIT, (Object)this.autoCommit);
        Preconditions.checkState((!StringUtils.isNullOrWhitespaceOnly((String)this.sql) ? 1 : 0) != 0, (Object)"'sql' mustn't be null or empty.");
        Preconditions.checkNotNull(this.resultExtractor, (String)"'resultExtractor' mustn't be null.");
        Preconditions.checkNotNull(this.typeInformation, (String)"'typeInformation' mustn't be null.");
        return new JdbcSource<OUT>(this.configuration, this.connectionProvider, new SqlTemplateSplitEnumerator.TemplateSqlSplitEnumeratorProvider().setOptionalSqlSplitEnumeratorState(null).setSqlTemplate(this.sql).setParameterValuesProvider(this.jdbcParameterValuesProvider), this.resultExtractor, this.typeInformation, this.deliveryGuarantee);
    }
}

