/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.dynamic.source.enumerator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.kafka.dynamic.metadata.ClusterMetadata;
import org.apache.flink.connector.kafka.dynamic.metadata.KafkaStream;
import org.apache.flink.connector.kafka.dynamic.source.enumerator.DynamicKafkaSourceEnumState;
import org.apache.flink.connector.kafka.source.enumerator.KafkaSourceEnumStateSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.Preconditions;

@Internal
public class DynamicKafkaSourceEnumStateSerializer
implements SimpleVersionedSerializer<DynamicKafkaSourceEnumState> {
    private static final int VERSION_1 = 1;
    private final KafkaSourceEnumStateSerializer kafkaSourceEnumStateSerializer = new KafkaSourceEnumStateSerializer();

    public int getVersion() {
        return 1;
    }

    /*
     * Exception decompiling
     */
    public byte[] serialize(DynamicKafkaSourceEnumState state) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public DynamicKafkaSourceEnumState deserialize(int version, byte[] serialized) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void serialize(Set<KafkaStream> kafkaStreams, DataOutputStream out) throws IOException {
        out.writeInt(kafkaStreams.size());
        for (KafkaStream kafkaStream : kafkaStreams) {
            out.writeUTF(kafkaStream.getStreamId());
            Map<String, ClusterMetadata> clusterMetadataMap = kafkaStream.getClusterMetadataMap();
            out.writeInt(clusterMetadataMap.size());
            for (Map.Entry<String, ClusterMetadata> entry : clusterMetadataMap.entrySet()) {
                String kafkaClusterId = entry.getKey();
                ClusterMetadata clusterMetadata = entry.getValue();
                out.writeUTF(kafkaClusterId);
                out.writeInt(clusterMetadata.getTopics().size());
                for (String topic : clusterMetadata.getTopics()) {
                    out.writeUTF(topic);
                }
                out.writeUTF((String)Preconditions.checkNotNull((Object)clusterMetadata.getProperties().getProperty("bootstrap.servers", "Bootstrap servers must be specified in properties")));
            }
        }
    }

    private Set<KafkaStream> deserialize(DataInputStream in) throws IOException {
        HashSet<KafkaStream> kafkaStreams = new HashSet<KafkaStream>();
        int numStreams = in.readInt();
        for (int i = 0; i < numStreams; ++i) {
            String streamId = in.readUTF();
            HashMap<String, ClusterMetadata> clusterMetadataMap = new HashMap<String, ClusterMetadata>();
            int clusterMetadataMapSize = in.readInt();
            for (int j = 0; j < clusterMetadataMapSize; ++j) {
                String kafkaClusterId = in.readUTF();
                int topicsSize = in.readInt();
                HashSet<String> topics = new HashSet<String>();
                for (int k = 0; k < topicsSize; ++k) {
                    topics.add(in.readUTF());
                }
                String bootstrapServers = in.readUTF();
                Properties properties = new Properties();
                properties.setProperty("bootstrap.servers", bootstrapServers);
                clusterMetadataMap.put(kafkaClusterId, new ClusterMetadata(topics, properties));
            }
            kafkaStreams.add(new KafkaStream(streamId, clusterMetadataMap));
        }
        return kafkaStreams;
    }

    private static byte[] readNBytes(DataInputStream in, int size) throws IOException {
        byte[] bytes = new byte[size];
        in.readFully(bytes);
        return bytes;
    }
}

