/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class DoubleSerializer
extends TypeSerializerSingleton<Double> {
    private static final long serialVersionUID = 1L;
    public static final DoubleSerializer INSTANCE = new DoubleSerializer();
    private static final Double ZERO = 0.0;

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public Double createInstance() {
        return ZERO;
    }

    @Override
    public Double copy(Double from) {
        return from;
    }

    @Override
    public Double copy(Double from, Double reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public void serialize(Double record, DataOutputView target) throws IOException {
        target.writeDouble(record);
    }

    @Override
    public Double deserialize(DataInputView source) throws IOException {
        return source.readDouble();
    }

    @Override
    public Double deserialize(Double reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeDouble(source.readDouble());
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof DoubleSerializer;
    }
}

