/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base.array;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class BytePrimitiveArraySerializer
extends TypeSerializerSingleton<byte[]> {
    private static final long serialVersionUID = 1L;
    private static final byte[] EMPTY = new byte[0];
    public static final BytePrimitiveArraySerializer INSTANCE = new BytePrimitiveArraySerializer();

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public byte[] createInstance() {
        return EMPTY;
    }

    @Override
    public byte[] copy(byte[] from) {
        byte[] copy = new byte[from.length];
        System.arraycopy(from, 0, copy, 0, from.length);
        return copy;
    }

    @Override
    public byte[] copy(byte[] from, byte[] reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(byte[] record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        int len = record.length;
        target.writeInt(len);
        target.write(record);
    }

    @Override
    public byte[] deserialize(DataInputView source) throws IOException {
        int len = source.readInt();
        byte[] result = new byte[len];
        source.readFully(result);
        return result;
    }

    @Override
    public byte[] deserialize(byte[] reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = source.readInt();
        target.writeInt(len);
        target.write(source, len);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof BytePrimitiveArraySerializer;
    }
}

