/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base.array;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class FloatPrimitiveArraySerializer
extends TypeSerializerSingleton<float[]> {
    private static final long serialVersionUID = 1L;
    private static final float[] EMPTY = new float[0];
    public static final FloatPrimitiveArraySerializer INSTANCE = new FloatPrimitiveArraySerializer();

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public float[] createInstance() {
        return EMPTY;
    }

    @Override
    public float[] copy(float[] from) {
        float[] copy = new float[from.length];
        System.arraycopy(from, 0, copy, 0, from.length);
        return copy;
    }

    @Override
    public float[] copy(float[] from, float[] reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(float[] record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        int len = record.length;
        target.writeInt(len);
        for (int i = 0; i < len; ++i) {
            target.writeFloat(record[i]);
        }
    }

    @Override
    public float[] deserialize(DataInputView source) throws IOException {
        int len = source.readInt();
        float[] result = new float[len];
        for (int i = 0; i < len; ++i) {
            result[i] = source.readFloat();
        }
        return result;
    }

    @Override
    public float[] deserialize(float[] reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = source.readInt();
        target.writeInt(len);
        target.write(source, len * 4);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof FloatPrimitiveArraySerializer;
    }
}

