/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.FSDataInputStream;

@Internal
public class LocalDataInputStream
extends FSDataInputStream {
    private FileInputStream fis = null;

    public LocalDataInputStream(File file) throws IOException {
        this.fis = new FileInputStream(file);
    }

    @Override
    public void seek(long desired) throws IOException {
        this.fis.getChannel().position(desired);
    }

    @Override
    public long getPos() throws IOException {
        return this.fis.getChannel().position();
    }

    @Override
    public int read() throws IOException {
        return this.fis.read();
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.fis.read(buffer, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.fis.close();
    }

    @Override
    public int available() throws IOException {
        return this.fis.available();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.fis.skip(n);
    }
}

