/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs.local;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.FSDataOutputStream;

@Internal
public class LocalDataOutputStream
extends FSDataOutputStream {
    private static final int MAX_OPEN_TRIES = 3;
    private FileOutputStream fos;

    public LocalDataOutputStream(File file) throws IOException {
        FileNotFoundException lastException = null;
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                this.fos = new FileOutputStream(file);
                return;
            }
            catch (FileNotFoundException e) {
                lastException = e;
                continue;
            }
        }
        throw lastException;
    }

    @Override
    public void write(int b) throws IOException {
        this.fos.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.fos.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.fos.close();
    }

    @Override
    public void flush() throws IOException {
        this.fos.flush();
    }

    @Override
    public void sync() throws IOException {
        this.fos.getFD().sync();
    }
}

