/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.reporter;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.groups.AbstractMetricGroup;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public abstract class AbstractReporter
implements MetricReporter,
CharacterFilter {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Map<Gauge<?>, String> gauges = new HashMap();
    protected final Map<Counter, String> counters = new HashMap<Counter, String>();
    protected final Map<Histogram, String> histograms = new HashMap<Histogram, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOfAddedMetric(Metric metric, String metricName, AbstractMetricGroup group) {
        String name = group.getMetricIdentifier(metricName, this);
        AbstractReporter abstractReporter = this;
        synchronized (abstractReporter) {
            if (metric instanceof Counter) {
                this.counters.put((Counter)metric, name);
            } else if (metric instanceof Gauge) {
                this.gauges.put((Gauge)metric, name);
            } else if (metric instanceof Histogram) {
                this.histograms.put((Histogram)metric, name);
            } else {
                this.log.warn("Cannot add unknown metric type {}. This indicates that the reporter does not support this metric type.", (Object)metric.getClass().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOfRemovedMetric(Metric metric, String metricName, AbstractMetricGroup group) {
        AbstractReporter abstractReporter = this;
        synchronized (abstractReporter) {
            if (metric instanceof Counter) {
                this.counters.remove(metric);
            } else if (metric instanceof Gauge) {
                this.gauges.remove(metric);
            } else if (metric instanceof Histogram) {
                this.histograms.remove(metric);
            } else {
                this.log.warn("Cannot remove unknown metric type {}. This indicates that the reporter does not support this metric type.", (Object)metric.getClass().getName());
            }
        }
    }
}

