/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.parser.FieldParser;

@PublicEvolving
public class BooleanParser
extends FieldParser<Boolean> {
    private boolean result;
    private static final byte[][] TRUE = new byte[][]{"true".getBytes(), "1".getBytes()};
    private static final byte[][] FALSE = new byte[][]{"false".getBytes(), "0".getBytes()};

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delim, Boolean reuse) {
        int i;
        int delimLimit = limit - delim.length + 1;
        for (i = startPos; !(i >= limit || i < delimLimit && BooleanParser.delimiterNext(bytes, i, delim)); ++i) {
        }
        for (byte[] aTRUE : TRUE) {
            if (!BooleanParser.byteArrayEquals(bytes, startPos, i - startPos, aTRUE)) continue;
            this.result = true;
            return i == limit ? limit : i + delim.length;
        }
        for (byte[] aFALSE : FALSE) {
            if (!BooleanParser.byteArrayEquals(bytes, startPos, i - startPos, aFALSE)) continue;
            this.result = false;
            return i == limit ? limit : i + delim.length;
        }
        this.setErrorState(FieldParser.ParseErrorState.BOOLEAN_INVALID);
        return -1;
    }

    @Override
    public Boolean getLastResult() {
        return this.result;
    }

    @Override
    public Boolean createValue() {
        return false;
    }

    private static boolean byteArrayEquals(byte[] source, int start, int length, byte[] other) {
        if (length != other.length) {
            return false;
        }
        for (int i = 0; i < other.length; ++i) {
            if (Character.toLowerCase(source[i + start]) == other[i]) continue;
            return false;
        }
        return true;
    }
}

