/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.parser.FieldParser;

@PublicEvolving
public class FloatValueParser
extends FieldParser<FloatValue> {
    private FloatValue result;

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, FloatValue reusable) {
        int i;
        int delimLimit = limit - delimiter.length + 1;
        for (i = startPos; !(i >= limit || i < delimLimit && FloatValueParser.delimiterNext(bytes, i, delimiter)); ++i) {
        }
        if (i > startPos && (Character.isWhitespace(bytes[startPos]) || Character.isWhitespace(bytes[i - 1]))) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_ILLEGAL_CHARACTER);
            return -1;
        }
        String str = new String(bytes, startPos, i - startPos);
        try {
            float value = Float.parseFloat(str);
            reusable.setValue(value);
            this.result = reusable;
            return i == limit ? limit : i + delimiter.length;
        }
        catch (NumberFormatException e) {
            this.setErrorState(FieldParser.ParseErrorState.NUMERIC_VALUE_FORMAT_ERROR);
            return -1;
        }
    }

    @Override
    public FloatValue createValue() {
        return new FloatValue();
    }

    @Override
    public FloatValue getLastResult() {
        return this.result;
    }
}

