/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.annotation.Internal;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

@Internal
public class MavenForkNumberPrefixLayout
extends PatternLayout {
    private static final String PROPERTY = "mvn.forkNumber";
    private final int prefixLength;
    private final StringBuilder stringBuilder;

    public MavenForkNumberPrefixLayout() {
        String prefix = System.getProperty(PROPERTY);
        if (prefix != null) {
            prefix = prefix + " > ";
            this.prefixLength = prefix.length();
            this.stringBuilder = new StringBuilder(512);
            this.stringBuilder.append(prefix);
        } else {
            this.prefixLength = 0;
            this.stringBuilder = null;
        }
    }

    public String format(LoggingEvent event) {
        if (this.prefixLength == 0) {
            return super.format(event);
        }
        this.stringBuilder.setLength(this.prefixLength);
        this.stringBuilder.append(super.format(event));
        return this.stringBuilder.toString();
    }
}

