/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobSubmissionResult;

@Public
public class JobExecutionResult
extends JobSubmissionResult {
    private long netRuntime;
    private Map<String, Object> accumulatorResults = Collections.emptyMap();

    public JobExecutionResult(JobID jobID, long netRuntime, Map<String, Object> accumulators) {
        super(jobID);
        this.netRuntime = netRuntime;
        if (accumulators != null) {
            this.accumulatorResults = accumulators;
        }
    }

    public long getNetRuntime() {
        return this.netRuntime;
    }

    public long getNetRuntime(TimeUnit desiredUnit) {
        return desiredUnit.convert(this.getNetRuntime(), TimeUnit.MILLISECONDS);
    }

    public <T> T getAccumulatorResult(String accumulatorName) {
        return (T)this.accumulatorResults.get(accumulatorName);
    }

    public Map<String, Object> getAllAccumulatorResults() {
        return this.accumulatorResults;
    }

    @Deprecated
    @PublicEvolving
    public Integer getIntCounterResult(String accumulatorName) {
        Object result = this.accumulatorResults.get(accumulatorName);
        if (result == null) {
            return null;
        }
        if (!(result instanceof Integer)) {
            throw new ClassCastException("Requested result of the accumulator '" + accumulatorName + "' should be Integer but has type " + result.getClass());
        }
        return (Integer)result;
    }

    @Deprecated
    public static JobExecutionResult fromJobSubmissionResult(JobSubmissionResult result) {
        return new JobExecutionResult(result.getJobID(), -1L, null);
    }
}

