/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.cache;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.flink.annotation.Public;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;

@Public
public class DistributedCache {
    private final Map<String, Future<Path>> cacheCopyTasks;
    private static final String CACHE_FILE_NUM = "DISTRIBUTED_CACHE_FILE_NUM";
    private static final String CACHE_FILE_NAME = "DISTRIBUTED_CACHE_FILE_NAME_";
    private static final String CACHE_FILE_PATH = "DISTRIBUTED_CACHE_FILE_PATH_";
    private static final String CACHE_FILE_EXE = "DISTRIBUTED_CACHE_FILE_EXE_";

    public DistributedCache(Map<String, Future<Path>> cacheCopyTasks) {
        this.cacheCopyTasks = cacheCopyTasks;
    }

    public File getFile(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null");
        }
        Future<Path> future = this.cacheCopyTasks.get(name);
        if (future == null) {
            throw new IllegalArgumentException("File with name '" + name + "' is not available." + " Did you forget to register the file?");
        }
        try {
            Path tmp = future.get();
            return new File(tmp.toString());
        }
        catch (ExecutionException e) {
            throw new RuntimeException("An error occurred while copying the file.", e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException("Error while getting the file registered under '" + name + "' from the distributed cache", e);
        }
    }

    public static void writeFileInfoToConfig(String name, DistributedCacheEntry e, Configuration conf) {
        int num = conf.getInteger(CACHE_FILE_NUM, 0) + 1;
        conf.setInteger(CACHE_FILE_NUM, num);
        conf.setString(CACHE_FILE_NAME + num, name);
        conf.setString(CACHE_FILE_PATH + num, e.filePath);
        conf.setBoolean(CACHE_FILE_EXE + num, e.isExecutable != false || new File(e.filePath).canExecute());
    }

    public static Set<Map.Entry<String, DistributedCacheEntry>> readFileInfoFromConfig(Configuration conf) {
        int num = conf.getInteger(CACHE_FILE_NUM, 0);
        if (num == 0) {
            return Collections.emptySet();
        }
        HashMap<String, DistributedCacheEntry> cacheFiles = new HashMap<String, DistributedCacheEntry>();
        for (int i = 1; i <= num; ++i) {
            String name = conf.getString(CACHE_FILE_NAME + i, null);
            String filePath = conf.getString(CACHE_FILE_PATH + i, null);
            Boolean isExecutable = conf.getBoolean(CACHE_FILE_EXE + i, false);
            cacheFiles.put(name, new DistributedCacheEntry(filePath, isExecutable));
        }
        return cacheFiles.entrySet();
    }

    public static class DistributedCacheEntry {
        public String filePath;
        public Boolean isExecutable;

        public DistributedCacheEntry(String filePath, Boolean isExecutable) {
            this.filePath = filePath;
            this.isExecutable = isExecutable;
        }
    }
}

