/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.functions.util;

import java.lang.reflect.Method;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.RichFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;

@Internal
public final class FunctionUtils {
    public static void openFunction(Function function, Configuration parameters) throws Exception {
        if (function instanceof RichFunction) {
            RichFunction richFunction = (RichFunction)function;
            richFunction.open(parameters);
        }
    }

    public static void closeFunction(Function function) throws Exception {
        if (function instanceof RichFunction) {
            RichFunction richFunction = (RichFunction)function;
            richFunction.close();
        }
    }

    public static void setFunctionRuntimeContext(Function function, RuntimeContext context) {
        if (function instanceof RichFunction) {
            RichFunction richFunction = (RichFunction)function;
            richFunction.setRuntimeContext(context);
        }
    }

    public static RuntimeContext getFunctionRuntimeContext(Function function, RuntimeContext defaultContext) {
        if (function instanceof RichFunction) {
            RichFunction richFunction = (RichFunction)function;
            return richFunction.getRuntimeContext();
        }
        return defaultContext;
    }

    public static Method checkAndExtractLambdaMethod(Function function) {
        try {
            Object serializedLambda = null;
            for (Class<?> clazz = function.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                try {
                    Method replaceMethod = clazz.getDeclaredMethod("writeReplace", new Class[0]);
                    replaceMethod.setAccessible(true);
                    Object serialVersion = replaceMethod.invoke((Object)function, new Object[0]);
                    if (!serialVersion.getClass().getName().equals("java.lang.invoke.SerializedLambda")) continue;
                    try {
                        Class.forName("java.lang.invoke.SerializedLambda");
                    }
                    catch (Exception e) {
                        throw new UnsupportedOperationException("User code tries to use lambdas, but framework is running with a Java version < 8");
                    }
                    serializedLambda = serialVersion;
                    break;
                }
                catch (NoSuchMethodException replaceMethod) {
                    // empty catch block
                }
            }
            if (serializedLambda == null) {
                return null;
            }
            Method implClassMethod = serializedLambda.getClass().getDeclaredMethod("getImplClass", new Class[0]);
            Method implMethodNameMethod = serializedLambda.getClass().getDeclaredMethod("getImplMethodName", new Class[0]);
            String className = (String)implClassMethod.invoke(serializedLambda, new Object[0]);
            String methodName = (String)implMethodNameMethod.invoke(serializedLambda, new Object[0]);
            Class<?> implClass = Class.forName(className.replace('/', '.'), true, Thread.currentThread().getContextClassLoader());
            Method[] methods = implClass.getDeclaredMethods();
            Method parameterizedMethod = null;
            for (Method method : methods) {
                if (!method.getName().equals(methodName)) continue;
                if (parameterizedMethod != null) {
                    throw new Exception("Lambda method name is not unique.");
                }
                parameterizedMethod = method;
            }
            if (parameterizedMethod == null) {
                throw new Exception("No lambda method found.");
            }
            return parameterizedMethod;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not extract lambda method out of function: " + e.getClass().getSimpleName() + " - " + e.getMessage(), e);
        }
    }

    private FunctionUtils() {
        throw new RuntimeException();
    }
}

