/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.ArrayList;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;

@Internal
public class Ordering
implements Cloneable {
    protected FieldList indexes = new FieldList();
    protected final ArrayList<Class<? extends Comparable<?>>> types = new ArrayList();
    protected final ArrayList<Order> orders = new ArrayList();

    public Ordering() {
    }

    public Ordering(int index, Class<? extends Comparable<?>> type, Order order) {
        this.appendOrdering(index, type, order);
    }

    public Ordering appendOrdering(Integer index, Class<? extends Comparable<?>> type, Order order) {
        if (index < 0) {
            throw new IllegalArgumentException("The key index must not be negative.");
        }
        if (order == null) {
            throw new NullPointerException();
        }
        if (order == Order.NONE) {
            throw new IllegalArgumentException("An ordering must not be created with a NONE order.");
        }
        this.indexes = this.indexes.addField(index);
        this.types.add(type);
        this.orders.add(order);
        return this;
    }

    public int getNumberOfFields() {
        return this.indexes.size();
    }

    public FieldList getInvolvedIndexes() {
        return this.indexes;
    }

    public Integer getFieldNumber(int index) {
        if (index < 0 || index >= this.indexes.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.indexes.get(index);
    }

    public Class<? extends Comparable<?>> getType(int index) {
        if (index < 0 || index >= this.types.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.types.get(index);
    }

    public Order getOrder(int index) {
        if (index < 0 || index >= this.types.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.orders.get(index);
    }

    public Class<? extends Comparable<?>>[] getTypes() {
        return this.types.toArray(new Class[this.types.size()]);
    }

    public int[] getFieldPositions() {
        int[] ia = new int[this.indexes.size()];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = this.indexes.get(i);
        }
        return ia;
    }

    public Order[] getFieldOrders() {
        return this.orders.toArray(new Order[this.orders.size()]);
    }

    public boolean[] getFieldSortDirections() {
        boolean[] directions = new boolean[this.orders.size()];
        for (int i = 0; i < directions.length; ++i) {
            directions[i] = this.orders.get(i) != Order.DESCENDING;
        }
        return directions;
    }

    public boolean isMetBy(Ordering otherOrdering) {
        if (otherOrdering == null || this.indexes.size() > otherOrdering.indexes.size()) {
            return false;
        }
        for (int i = 0; i < this.indexes.size(); ++i) {
            if (this.indexes.get(i) != otherOrdering.indexes.get(i)) {
                return false;
            }
            if (this.orders.get(i) == Order.NONE || !(this.orders.get(i) == Order.ANY ? otherOrdering.orders.get(i) == Order.NONE : otherOrdering.orders.get(i) != this.orders.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isOrderEqualOnFirstNFields(Ordering other, int n) {
        if (n > this.getNumberOfFields() || n > other.getNumberOfFields()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n; ++i) {
            Order o = this.orders.get(i);
            if (o != Order.NONE && o != Order.ANY && o == other.orders.get(i)) continue;
            return false;
        }
        return true;
    }

    public Ordering createNewOrderingUpToIndex(int exclusiveIndex) {
        if (exclusiveIndex == 0) {
            return null;
        }
        Ordering newOrdering = new Ordering();
        for (int i = 0; i < exclusiveIndex; ++i) {
            newOrdering.appendOrdering(this.indexes.get(i), this.types.get(i), this.orders.get(i));
        }
        return newOrdering;
    }

    public boolean groupsFields(FieldSet fields) {
        if (fields.size() > this.indexes.size()) {
            return false;
        }
        for (int i = 0; i < fields.size(); ++i) {
            if (fields.contains(this.indexes.get(i))) continue;
            return false;
        }
        return true;
    }

    public Ordering clone() {
        Ordering newOrdering = new Ordering();
        newOrdering.indexes = this.indexes;
        newOrdering.types.addAll(this.types);
        newOrdering.orders.addAll(this.orders);
        return newOrdering;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.indexes == null ? 0 : this.indexes.hashCode());
        result = 31 * result + (this.orders == null ? 0 : this.orders.hashCode());
        result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Ordering other = (Ordering)obj;
        if (this.indexes == null ? other.indexes != null : !this.indexes.equals(other.indexes)) {
            return false;
        }
        if (this.orders == null ? other.orders != null : !this.orders.equals(other.orders)) {
            return false;
        }
        return !(this.types == null ? other.types != null : !this.types.equals(other.types));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        for (int i = 0; i < this.indexes.size(); ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.indexes.get(i));
            if (this.types.get(i) != null) {
                buf.append(":");
                buf.append(this.types.get(i).getName());
            }
            buf.append(":");
            buf.append(this.orders.get(i).getShortName());
        }
        buf.append("]");
        return buf.toString();
    }
}

