/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;

@Internal
public final class ListKeyGroupedIterator<E> {
    private final List<E> input;
    private final TypeSerializer<E> serializer;
    private final TypeComparator<E> comparator;
    private ValuesIterator valuesIterator;
    private int currentPosition = 0;
    private E lookahead;
    private boolean done;

    public ListKeyGroupedIterator(List<E> input, TypeSerializer<E> serializer, TypeComparator<E> comparator) {
        if (input == null || comparator == null) {
            throw new NullPointerException();
        }
        this.input = input;
        this.serializer = serializer;
        this.comparator = comparator;
        this.done = input.isEmpty();
    }

    public boolean nextKey() throws IOException {
        E first;
        if (this.lookahead != null) {
            this.comparator.setReference(this.lookahead);
            this.valuesIterator.next = this.lookahead;
            this.lookahead = null;
            return true;
        }
        if (this.done) {
            return false;
        }
        if (this.valuesIterator != null) {
            E next;
            while (this.currentPosition < this.input.size() && (next = this.input.get(this.currentPosition++)) != null) {
                if (this.comparator.equalToReference(next)) continue;
                this.comparator.setReference(next);
                this.valuesIterator.next = next;
                return true;
            }
            this.valuesIterator.next = null;
            this.valuesIterator = null;
            this.done = true;
            return false;
        }
        if ((first = this.input.get(this.currentPosition++)) != null) {
            this.comparator.setReference(first);
            this.valuesIterator = new ValuesIterator(first, this.serializer);
            return true;
        }
        this.done = true;
        return false;
    }

    private E advanceToNext() {
        if (this.currentPosition < this.input.size()) {
            E next;
            if (this.comparator.equalToReference(next = this.input.get(this.currentPosition++))) {
                return next;
            }
            this.lookahead = next;
            return null;
        }
        this.done = true;
        return null;
    }

    public ValuesIterator getValues() {
        return this.valuesIterator;
    }

    public final class ValuesIterator
    implements Iterator<E>,
    Iterable<E> {
        private E next;
        private final TypeSerializer<E> serializer;

        private ValuesIterator(E first, TypeSerializer<E> serializer) {
            this.next = first;
            this.serializer = serializer;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next != null) {
                Object current = this.next;
                this.next = ListKeyGroupedIterator.this.advanceToNext();
                return this.serializer.copy(current);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            return this;
        }

        public E getCurrent() {
            return this.next;
        }
    }
}

