/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateBackend;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;

@PublicEvolving
public abstract class StateDescriptor<S extends State, T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String name;
    protected TypeSerializer<T> serializer;
    protected transient T defaultValue;
    private transient TypeInformation<T> typeInfo;

    protected StateDescriptor(String name, TypeSerializer<T> serializer, T defaultValue) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.serializer = Objects.requireNonNull(serializer, "serializer must not be null");
        this.defaultValue = defaultValue;
    }

    protected StateDescriptor(String name, TypeInformation<T> typeInfo, T defaultValue) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.typeInfo = Objects.requireNonNull(typeInfo, "type information must not be null");
        this.defaultValue = defaultValue;
    }

    protected StateDescriptor(String name, Class<T> type, T defaultValue) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(type, "type class must not be null");
        try {
            this.typeInfo = TypeExtractor.createTypeInfo(type);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create full type information based on the given class. If the type has generics, please", e);
        }
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public T getDefaultValue() {
        if (this.defaultValue != null) {
            if (this.serializer != null) {
                return this.serializer.copy(this.defaultValue);
            }
            throw new IllegalStateException("Serializer not yet initialized.");
        }
        return null;
    }

    public TypeSerializer<T> getSerializer() {
        if (this.serializer != null) {
            return this.serializer;
        }
        throw new IllegalStateException("Serializer not yet initialized.");
    }

    public abstract S bind(StateBackend var1) throws Exception;

    public boolean isSerializerInitialized() {
        return this.serializer != null;
    }

    public void initializeSerializerUnlessSet(ExecutionConfig executionConfig) {
        if (this.serializer == null) {
            if (this.typeInfo != null) {
                this.serializer = this.typeInfo.createSerializer(executionConfig);
            } else {
                throw new IllegalStateException("Cannot initialize serializer after TypeInformation was dropped during serialization");
            }
        }
    }

    private void ensureSerializerCreated() {
        if (this.serializer == null) {
            if (this.typeInfo != null) {
                this.serializer = this.typeInfo.createSerializer(new ExecutionConfig());
            } else {
                throw new IllegalStateException("Cannot initialize serializer after TypeInformation was dropped during serialization");
            }
        }
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.name + ", defaultValue=" + this.defaultValue + ", serializer=" + this.serializer + '}';
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.ensureSerializerCreated();
        out.defaultWriteObject();
        if (this.defaultValue == null) {
            out.writeBoolean(false);
        } else {
            byte[] serializedDefaultValue;
            out.writeBoolean(true);
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 DataOutputViewStreamWrapper outView = new DataOutputViewStreamWrapper(baos);){
                TypeSerializer<T> duplicateSerializer = this.serializer.duplicate();
                duplicateSerializer.serialize(this.defaultValue, outView);
                outView.flush();
                serializedDefaultValue = baos.toByteArray();
            }
            catch (Exception e) {
                throw new IOException("Unable to serialize default value of type " + this.defaultValue.getClass().getSimpleName() + ".", e);
            }
            out.writeInt(serializedDefaultValue.length);
            out.write(serializedDefaultValue);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block27: {
            in.defaultReadObject();
            boolean hasDefaultValue = in.readBoolean();
            if (hasDefaultValue) {
                int size = in.readInt();
                byte[] buffer = new byte[size];
                in.readFully(buffer);
                try (ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
                     DataInputViewStreamWrapper inView = new DataInputViewStreamWrapper(bais);){
                    this.defaultValue = this.serializer.deserialize(inView);
                    break block27;
                }
                catch (Exception e) {
                    throw new IOException("Unable to deserialize default value.", e);
                }
            }
            this.defaultValue = null;
        }
    }
}

