/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class BigIntSerializer
extends TypeSerializerSingleton<BigInteger> {
    private static final long serialVersionUID = 1L;
    public static final BigIntSerializer INSTANCE = new BigIntSerializer();

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public BigInteger createInstance() {
        return BigInteger.ZERO;
    }

    @Override
    public BigInteger copy(BigInteger from) {
        return from;
    }

    @Override
    public BigInteger copy(BigInteger from, BigInteger reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(BigInteger record, DataOutputView target) throws IOException {
        BigIntSerializer.writeBigInteger(record, target);
    }

    @Override
    public BigInteger deserialize(DataInputView source) throws IOException {
        return BigIntSerializer.readBigInteger(source);
    }

    @Override
    public BigInteger deserialize(BigInteger reuse, DataInputView source) throws IOException {
        return BigIntSerializer.readBigInteger(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        BigIntSerializer.copyBigInteger(source, target);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof BigIntSerializer;
    }

    public static void writeBigInteger(BigInteger record, DataOutputView target) throws IOException {
        if (record == null) {
            target.writeInt(0);
            return;
        }
        if (record == BigInteger.ZERO) {
            target.writeInt(1);
            return;
        }
        if (record == BigInteger.ONE) {
            target.writeInt(2);
            return;
        }
        if (record == BigInteger.TEN) {
            target.writeInt(3);
            return;
        }
        byte[] bytes = record.toByteArray();
        target.writeInt(bytes.length + 4);
        target.write(bytes);
    }

    public static BigInteger readBigInteger(DataInputView source) throws IOException {
        int len = source.readInt();
        if (len < 4) {
            switch (len) {
                case 0: {
                    return null;
                }
                case 1: {
                    return BigInteger.ZERO;
                }
                case 2: {
                    return BigInteger.ONE;
                }
                case 3: {
                    return BigInteger.TEN;
                }
            }
        }
        byte[] bytes = new byte[len - 4];
        source.read(bytes);
        return new BigInteger(bytes);
    }

    public static boolean copyBigInteger(DataInputView source, DataOutputView target) throws IOException {
        int len = source.readInt();
        target.writeInt(len);
        if (len > 4) {
            target.write(source, len - 4);
        }
        return len == 0;
    }
}

