/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@Internal
public final class EnumSerializer<T extends Enum<T>>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 1L;
    private transient T[] values;
    private final Class<T> enumClass;

    public EnumSerializer(Class<T> enumClass) {
        this.enumClass = Preconditions.checkNotNull(enumClass);
        this.values = (Enum[])EnumSerializer.createValues(enumClass);
    }

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public EnumSerializer<T> duplicate() {
        return this;
    }

    @Override
    public T createInstance() {
        return this.values[0];
    }

    @Override
    public T copy(T from) {
        return from;
    }

    @Override
    public T copy(T from, T reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public void serialize(T record, DataOutputView target) throws IOException {
        target.writeInt(((Enum)record).ordinal());
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        return this.values[source.readInt()];
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        return this.values[source.readInt()];
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.write(source, 4);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof EnumSerializer) {
            EnumSerializer other = (EnumSerializer)obj;
            return other.canEqual(this) && other.enumClass == this.enumClass;
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof EnumSerializer;
    }

    @Override
    public int hashCode() {
        return this.enumClass.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.values = (Enum[])EnumSerializer.createValues(this.enumClass);
    }

    private static <T> T[] createValues(Class<T> enumClass) {
        try {
            Method valuesMethod = enumClass.getMethod("values", new Class[0]);
            return (Object[])valuesMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot access the constants of the enum " + enumClass.getName());
        }
    }
}

