/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class ShortSerializer
extends TypeSerializerSingleton<Short> {
    private static final long serialVersionUID = 1L;
    public static final ShortSerializer INSTANCE = new ShortSerializer();
    private static final Short ZERO = 0;

    @Override
    public boolean isImmutableType() {
        return true;
    }

    @Override
    public Short createInstance() {
        return ZERO;
    }

    @Override
    public Short copy(Short from) {
        return from;
    }

    @Override
    public Short copy(Short from, Short reuse) {
        return from;
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public void serialize(Short record, DataOutputView target) throws IOException {
        target.writeShort(record.shortValue());
    }

    @Override
    public Short deserialize(DataInputView source) throws IOException {
        return source.readShort();
    }

    @Override
    public Short deserialize(Short reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeShort(source.readShort());
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof ShortSerializer;
    }
}

