/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.util.Utf8;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;

@Public
public class AvroTypeInfo<T extends SpecificRecordBase>
extends PojoTypeInfo<T> {
    @PublicEvolving
    public AvroTypeInfo(Class<T> typeClass) {
        super(typeClass, AvroTypeInfo.generateFieldsFromAvroSchema(typeClass));
    }

    private static <T extends SpecificRecordBase> List<PojoField> generateFieldsFromAvroSchema(Class<T> typeClass) {
        PojoTypeExtractor pte = new PojoTypeExtractor();
        ArrayList<Type> typeHierarchy = new ArrayList<Type>();
        typeHierarchy.add(typeClass);
        TypeInformation<T> ti = pte.analyzePojo(typeClass, typeHierarchy, null, null, null);
        if (!(ti instanceof PojoTypeInfo)) {
            throw new IllegalStateException("Expecting type to be a PojoTypeInfo");
        }
        PojoTypeInfo pti = (PojoTypeInfo)ti;
        ArrayList<PojoField> newFields = new ArrayList<PojoField>(pti.getTotalFields());
        for (int i = 0; i < pti.getArity(); ++i) {
            PojoField f = pti.getPojoFieldAt(i);
            TypeInformation<?> newType = f.getTypeInformation();
            if (newType instanceof GenericTypeInfo && newType.getTypeClass().equals(CharSequence.class)) {
                newType = new GenericTypeInfo<Utf8>(Utf8.class);
            }
            PojoField newField = new PojoField(f.getField(), newType);
            newFields.add(newField);
        }
        return newFields;
    }

    private static class PojoTypeExtractor
    extends TypeExtractor {
        private PojoTypeExtractor() {
        }
    }
}

