/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.WritableComparator;
import org.apache.flink.api.java.typeutils.runtime.WritableSerializer;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.io.Writable;

@Public
public class WritableTypeInfo<T extends Writable>
extends TypeInformation<T>
implements AtomicType<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> typeClass;

    @PublicEvolving
    public WritableTypeInfo(Class<T> typeClass) {
        this.typeClass = Preconditions.checkNotNull(typeClass);
        Preconditions.checkArgument(Writable.class.isAssignableFrom(typeClass) && !typeClass.equals(Writable.class), "WritableTypeInfo can only be used for subclasses of %s", Writable.class.getName());
    }

    @Override
    @PublicEvolving
    public TypeComparator<T> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        if (Comparable.class.isAssignableFrom(this.typeClass)) {
            return new WritableComparator<T>(sortOrderAscending, this.typeClass);
        }
        throw new UnsupportedOperationException("Cannot create Comparator for " + this.typeClass.getCanonicalName() + ". " + "Class does not implement Comparable interface.");
    }

    @Override
    @PublicEvolving
    public boolean isBasicType() {
        return false;
    }

    @Override
    @PublicEvolving
    public boolean isTupleType() {
        return false;
    }

    @Override
    @PublicEvolving
    public int getArity() {
        return 1;
    }

    @Override
    @PublicEvolving
    public int getTotalFields() {
        return 1;
    }

    @Override
    @PublicEvolving
    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @Override
    @PublicEvolving
    public boolean isKeyType() {
        return Comparable.class.isAssignableFrom(this.typeClass);
    }

    @Override
    @PublicEvolving
    public TypeSerializer<T> createSerializer(ExecutionConfig executionConfig) {
        return new WritableSerializer<T>(this.typeClass);
    }

    @Override
    public String toString() {
        return "WritableType<" + this.typeClass.getName() + ">";
    }

    @Override
    public int hashCode() {
        return this.typeClass.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof WritableTypeInfo) {
            WritableTypeInfo writableTypeInfo = (WritableTypeInfo)obj;
            return writableTypeInfo.canEqual(this) && this.typeClass == writableTypeInfo.typeClass;
        }
        return false;
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof WritableTypeInfo;
    }

    @PublicEvolving
    static <T extends Writable> TypeInformation<T> getWritableTypeInfo(Class<T> typeClass) {
        if (Writable.class.isAssignableFrom(typeClass) && !typeClass.equals(Writable.class)) {
            return new WritableTypeInfo<T>(typeClass);
        }
        throw new InvalidTypesException("The given class is no subclass of " + Writable.class.getName());
    }
}

