/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.InstantiationUtil;

public final class RuntimeComparatorFactory<T>
implements TypeComparatorFactory<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CONFIG_KEY = "SER_DATA";
    private TypeComparator<T> comparator;

    public RuntimeComparatorFactory() {
    }

    public RuntimeComparatorFactory(TypeComparator<T> comparator) {
        this.comparator = comparator;
    }

    @Override
    public void writeParametersToConfig(Configuration config) {
        try {
            InstantiationUtil.writeObjectToConfig(this.comparator, config, CONFIG_KEY);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not serialize comparator into the configuration.", e);
        }
    }

    @Override
    public void readParametersFromConfig(Configuration config, ClassLoader cl) throws ClassNotFoundException {
        try {
            this.comparator = (TypeComparator)InstantiationUtil.readObjectFromConfig(config, CONFIG_KEY, cl);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not serialize serializer into the configuration.", e);
        }
    }

    @Override
    public TypeComparator<T> createComparator() {
        if (this.comparator != null) {
            return this.comparator;
        }
        throw new RuntimeException("ComparatorFactory has not been initialized from configuration.");
    }
}

